function [msh,lights,tenseMsh] = fs_MLRMesh2FS(filename,outFileName);
%
%   [msh,lights,tenseMsh] = fs_MLRMesh2FS(filename,outFileName);
%
%
%
% Author: ARW (based on RFD's mrmBuildMesh)
% Purpose:
%  Take a mesh generated by mrMesh and turns it into a Freesurfer surface
%  mesh. Why? Because we want to use the F sphere and register routines to
%  do averaging across subjects on the cortical mesh.
% All the vertices are kept (no decimation) . And it looks like FS
% preserves vertices once it generates its .orig surface
% Things are pretty striaghtforward except that we need to generate faces
% from the conmat  in mrmesh msh structures and make sure that they are
% pointing the right way...
% We also need to (or at least we >can< save out a curvature file.
%

mrGlobals;

if ieNotDefined('filename')
    [filename,pathname]=uigetfile('*.mat','Pick a mrMesh mesh file');
    filename=fullfile(pathname,filename);
end

m=load(filename);
vertex=m.msh.initVertices; % We need to fiddle with these a little. Firstly 
                            % mrMesh has 0,0,0 at the corner of the
                            % reference frame while FS has it in the
                            % middle. So we need to subtract 128 from all
                            % numbers
vertex=round(vertex'-128);
vertex(vertex>127)=127;
vertex(vertex<-127)=-127;


% There's probably some additional rotation that needs to happen. But we
% skip this for now..

face=(m.msh.data.triangles')+1; % Referencing?
disp('adding 1 to triangle indices');

if ieNotDefined('outFileName')
    [filename,pathname]=uiputfile('*.*','Pick a FS surface file');
    outFileName=fullfile(pathname,filename);
end
size(vertex)
size(face)
crv=m.msh.curvature;
outFileNameCurv=[outFileName,'_curv'];
freesurfer_write_surf(outFileName,vertex,face);
disp('Writing curv');

freesurfer_write_curv(outFileNameCurv,crv,length(face'));


