function varargout = siemensHeaderParams(hdr, paramName)

% SYNTAX:
% val = siemensHeaderParams(hdr, 'NumberOfImagesInMosaic')
%   takes dicom structure hdr and looks in propriety header info for requested
%   information i.e. 'NumberOfImagesInMosaic'.  
% 
% val = siemensHeaderParams(hdr)
%  returns cell array containing all the available values in propriety
%  header info
%
% val = siemensHeaderParams(hdr, 'update')
%  returns original header with resolved 'Private_0029_1010' field as 'CSAImageHeaderInfo' field

if ~isstruct(hdr)   
    error('Invalid input')
elseif isfield(hdr, 'CSAImageHeaderInfo') 
    % already got correct field
elseif ~isfield(hdr, 'CSAImageHeaderInfo') & isfield(hdr, 'Private_0029_1010')
    % likely header read with matlabs dicominfo
    hdr.CSAImageHeaderInfo = decode_csa(hdr);
else
    error('Unkown header')
end


val = {hdr.CSAImageHeaderInfo.name};
if nargout > 1, varargout{1} = val; end

if nargin == 1
    return
    
elseif strmatch(lower(paramName), 'update', 'exact')
    varargout{1} = hdr;    
    
elseif strmatch(lower(paramName), 'print')
    for i = 1:length(val)
        try
            dat = getValue(hdr, i);
        catch
            dat = '';
        end
        fprintf('%d.  %s: %s\n', i,val{i}, dat)
    end
    
    
else
    sub = strmatch( lower(paramName), lower(val));
    if isempty(sub)
        % undelete for verbose
        %fprintf('Unkown parameter ''%s''. Possibles are: \n', paramName)
        %fprintf('%s, ', hdr.CSAImageHeaderInfo.name)
        %fprintf('\b\b\n')
        fprintf('Unkown data field ''%s''\n', paramName)

    else
        %val = hdr.CSAImageHeaderInfo(sub).item(1).val;
        
        varargout{1} = getValue(hdr, sub);
    end
    return
end

% _______________________________________________________________________
function r = getValue(hdr, index)

val = {hdr.CSAImageHeaderInfo.name};  % get names of siemens fields

switch lower(val{index})
    case 'slicenormalvector', r = [ hdr.CSAImageHeaderInfo(index).item(:).val ];
    otherwise r = [ hdr.CSAImageHeaderInfo(index).item(:).val ];
end

% make sure string can be printed. Swap newline for space
r( double(r)==0 ) = ' ';


% _______________________________________________________________________
function t = decode_csa(hdr)
% Decode shadow information (0029,1010) and (0029,1020)


c   = hdr.Private_0029_1010(1:4);

if all(c'==[83 86 49 48]), % "SV10"
	t = decode_csa2(hdr.Private_0029_1010(5:length(hdr.Private_0029_1010)));
else,
	t = decode_csa1(hdr);
end;

%_______________________________________________________________________

%_______________________________________________________________________
function t = decode_csa1(CSA)
n   = max(CSA(1:4)); CSA(1:4)=[];
if n>128 | n < 0,
	t = struct('junk','Don''t know how to read this damned file format');
	return;
end;

xx  = CSA(1:4); CSA(1:4)=[];%fread(fp,1,'uint32')'; % "M" or 77 for some reason
tot = 2*4;
for i=1:n,
	t(i).name    = CSA(1:64); CSA(1:64) = []; %fread(fp,64,'char')';
	msk          = find(~t(i).name)-1;
	if ~isempty(msk),
		t(i).name    = char(t(i).name(1:msk(1)));
	else,
		t(i).name    = char(t(i).name);
	end;
	t(i).vm      = CSA(1:4); CSA(1:4)=[]; %fread(fp,1,'int32')';
	t(i).vr      = CSA(1:4); CSA(1:4) = []; %fread(fp,4,'char')';
	t(i).vr      = char(t(i).vr(1:3));
	t(i).syngodt = CSA(1:4); CSA(1:4)=[]; %fread(fp,1,'int32')';
	t(i).nitems  = CSA(1:4); CSA(1:4)=[]; %fread(fp,1,'int32')';
	t(i).xx      = CSA(1:4); CSA(1:4)=[]; %fread(fp,1,'int32')'; % 77 or 205
	tot          = tot + 64+4+4+4+4+4;
	for j=1:t(i).nitems
		% This bit is just wierd
		t(i).item(j).xx  = max(CSA(1:4)); CSA(1:4)=[]; %fread(fp,4,'int32')'; % [x x 77 x]
		len              = t(i).item(j).xx(1)-t(1).nitems;
		if len<0 | len+tot+4*4>lim,
			t(i).item(j).val = '';
			tot              = tot + 4*4;
			break;
		end;
		t(i).item(j).val = CSA(1:len); CSA(1:len)=[];% char(fread(fp,len,'char'))';
		CSA(1:4-rem(len,4))=[]; %fread(fp,4-rem(len,4),'char')';
		tot              = tot + 4*4+len+(4-rem(len,4));
	end;
end;
return;
%_______________________________________________________________________

%_______________________________________________________________________
function t = decode_csa2(CSA)
c   = CSA(1:4); CSA(1:4)=[]; %fread(fp,4,'char');
%n   = fread(fp,4,'char');
n   = CSA(1:4); CSA(1:4) = []; %fread(fp,1,'uint32');
if n>128 | n < 0,
	t = struct('junk','Don''t know how to read this damned file format');
	return;
end;
xx  = CSA(1:4); CSA(1:4) = []; %fread(fp,1,'uint32')'; % "M" or 77 for some reason
disp(n) %debug code
for i=1:n(1)
	t(i).name    = CSA(1:64)'; CSA(1:64) = []; %fread(fp,64,'char')';
	msk          = find(~t(i).name)-1;
	if ~isempty(msk),
		t(i).name    = char(t(i).name(1:msk(1)));
	else,
		t(i).name    = char(t(i).name);
	end;
	t(i).vm      = CSA(1:4)'; CSA(1:4)=[]; %fread(fp,1,'int32')';
	t(i).vr      = CSA(1:4)'; CSA(1:4)=[];   %fread(fp,4,'char')';
	t(i).vr      = char(t(i).vr(1:3));
	t(i).syngodt = max(CSA(1:4)'); CSA(1:4)=[]; %fread(fp,1,'int32')';
	t(i).nitems  = max(CSA(1:4)'); CSA(1:4)=[]; %fread(fp,1,'int32')';
	t(i).xx      = max(CSA(1:4)'); CSA(1:4)=[]; %fread(fp,1,'int32')'; % 77 or 205
	for j=1:t(i).nitems
		t(i).item(j).xx  = CSA(1:4:16)'; CSA(1:16)=[]; %fread(fp,4,'int32')'; % [x x 77 x]
		len              = t(i).item(j).xx(2);
		t(i).item(j).val = char( CSA(1:len) )'; CSA(1:len) = []; %char(fread(fp,len,'char'))';
		CSA(1: rem(4-rem(len,4),4)) = []; %   fread(fp,rem(4-rem(len,4),4),'char');
	end;
end;
return;
    