function make_data_links(subject_ID, scan_ID, dest_dir)

% function to make links to the /mnt/mridata
% directory

if nargin < 3
    dest_dir = pwd;
end

disp(['This is the directory where you data links will be created ',dest_dir]);
data_dir = fullfile('/mnt/mridata',subject_ID, scan_ID);
disp(['This is the source directory ',data_dir]);
dir_list = dir(data_dir);
for i = 1:length(dir_list);
    if dir_list(i).isdir
        if length(dir_list(i).name) > 1 & dir_list(i).name(2) == '_'
            [success, message] = mkdir(dest_dir, dir_list(i).name);
            if success
                file_source = fullfile(data_dir,dir_list(i).name,'*');
                file_dest = fullfile(dest_dir,dir_list(i).name);
                evalstr = ['!ln -s ',file_source, ' ', file_dest];
                eval(evalstr);
                disp(['The directory ', dest_dir,'/',dir_list(i).name, ' has been created locally and files have been linked to source'])
            end
        end
    end
end



