function created_inplane_from_first_fMRI_vol(f_path, noMosaics)
%Andre Gouws YNiC 2007
%created to automatically create an inplane for data acquired at Holloway
%for the first volume in the first fMRI directory created by sort_siemens_data

disp(f_path)
disp(f_path)
disp(f_path)

filestring = ' ';

for i = 1:noMosaics
    filestring = sprintf('%s %s/MR%06d',filestring,f_path,i);
end

anat_output_path = sprintf('%s/../101_anat/anat' ,f_path)

evalStr1 = ['!mkdir ',f_path,'/../101_anat'];
eval(evalStr1);

evalStr1 = ['!medcon -f',filestring,' -c anlz -stacks -o ',anat_output_path,' -noprefix'];
eval(evalStr1);

[anat, inplanes] = GetAnatomy([f_path,'/../101_anat/']);

for i=1:noMosaics
    anat(:,:,i)=flipLR(squeeze(anat(:,:,i)));
end

for i=1:noMosaics
    anat(:,:,i)=rot90(squeeze(anat(:,:,i)),1);
end

save([anat_output_path,'.mat'], 'anat', 'inplanes');
evalStr1 = ['!mv ',f_path,'/../101_anat/anat.mat ',f_path,'/../anat.mat '];
eval(evalStr1);
