function YNiC_prep(subjectName,SessionName)
% YNiC_prep(subjectName,SessionName)
% This is a script to recon the dicom files that come from the YNiC MRI
% scanner at the University of York.  Code has been adapted from the
% prepare_UCSF function that the SKERI guys wrote (thanks).
%
% The first part uses the medcon program to convert those files into
% analyze format. After that, we use FSL to do some preprocessing like
% motion correction. 
% The final step is to generate a mrLoadRet project from the set of 4d
% Analyze files.
% Motion correction is performed in several stages: We first do within-scan
% MC and store all the resulting transform matrices for each scan. Then we
% do between-scan MC using the mean image from each scan to align everything to the
% first scan in the session. We store the transforms for these alignments
% as well.
% Then we go back and combine the within and between scan transforms and
% re-apply the entire transform to the original data set. In this way we
% avoid re-sampling the original data more than we have to.
% EXAMPLE: YNiC_prep('R1100','200607011347_P1025');
%
% 2006.04.20 Mark Schira (mark@ski.org) authored the original prepare_UCSF
% 2006.07.31 Tony Morland (a.morland@psych.york.ac.uk) reworked the code
% for YNiC

if not(exist('subjectName'))
    error('need the lastname of subject as input');
end

if not(exist('SessionName'))
    SessionName='Whatever';
end

% Comment this to make work on PC for testing functionality
operatingSystem=computer;
% if not(strcmp(operatingSystem(1:4),'GLNX'))
%     error('written for linux, use syms or fitz!')
% end
datestr(now)
ActionList={'Nothing','Inplanes','Functional','RefFunc'};  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Stuff for fsl 
% This line is for SKERI
% fslBase='/raid/MRI/toolbox/FSL/fsl';
% let's try this base dir for YNiC - ABM 2006-05-18
fslBase = '/opt/fsl';

if (ispref('VISTA','fslBase'))
    disp('Setting fslBase to the one specified in the VISTA matlab preferences:');
    fslBase=getpref('VISTA','fslBase');
    disp(fslBase);
end

fslPath=fullfile(fslBase,'bin'); % This is where FSL lives - should also be able to get this from a Matlab pref
% have commented the line below because I don't think we are ever going to
% get .mag files - ABM 2006-05-18
%reconPath='/raid/MRI/toolbox/Recon'; % required for the recon program to convert .mag files into Analyze format


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Opening dialogs
% We present the user with a list of options. Not all stages have to be
% performed at once.

initOptions = {'clean previous files (be careful!)',...
        'DB Query',...
        'Do Detect data',...
        'Generate MLR structure',...
        'Generare BV structure',...
        'Motion cor. in scan',...
        'Motion cor. between scan',...
        'Perform blocked analysis',...
        'Perform event related analysis',...
        'Clean up, delete analyze files',...
        'Clean up. Zip the Dicom files',...
    };
initReply=[0 1 1 1 0 1 1 1 0 1 1]; % These are the defaults
initReply = buttondlg('mrInit UCSF-Data', initOptions,initReply); % need to check this for YNiC
if length(find(initReply)) == 0, return; end

pause(0.2); 
cleanfirst=initReply(1);
doDBQuery=initReply(2);
detectData=initReply(3);
doMLR=initReply(4);
doBV=initReply(5);
motionInScan=initReply(6);
motionBetween=initReply(7);
blockedData=initReply(8);
eventData=initReply(9);
doCleanUp=initReply(10);
doPackDicom=initReply(11);

baseDir = pwd;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% remove analyze file from previous runs
%%

if cleanfirst
    ! rm ./*/*.hdr
    ! rm ./*/*.img
    ! rm ./Inplane/*
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Automatic detection of the Directories, Inplanes etc
% If we were smart here, we could auto detect the analyze files that have
% already been written out at YNiC - ABM 2006-08-01
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if detectData
    disp('Reading the directory structure...');
    baseDirListing=dir;
    %checkforAnalyzeFiles = dir('*.hdr');
    if baseDirListing(1).name=='.' & operatingSystem(1) == 'G'
        baseDirListing=baseDirListing(3:end);
    elseif baseDirListing(1).name=='.' & operatingSystem == 'MAC'
        baseDirListing=baseDirListing(3:end);
%     elseif size(checkforAnalyzeFiles,1) > 0
%         %do nothing for now!
    end
    foundScans(1).DirName='1';
    foundScans(1).Files=0;
    foundScans(1).Slices=0;
    foundScans(1).Volumes=0;
    foundScans(1).Sequence='';
    foundScans(1).Action='';
    foundScans(1).Filenames='';
    foundScans(1).SkipVols='';
    foundScans(1).Cycles='';
    foundScans(1).Filename4d='';
    foundScans(1).lastfile='';
    inplanedir=0;
    

    for thisEntry=1:length(baseDirListing)
        %disp(thisEntry);
        if baseDirListing(thisEntry).isdir
            try
                thisdir = str2num(baseDirListing(thisEntry).name(1)); %works for n_SeriesDescription directory structure (YNiC) - changed from n structure (SKERI)
                disp([num2str(thisdir), baseDirListing(thisEntry).name(2:end)]); % changed to show the right directory names
                if strcmp(num2str(thisdir),baseDirListing(thisEntry).name(1)) % changed to match the appropriate part of the dir name
                    eval(['cd ', baseDirListing(thisEntry).name])
                    disp(['changing directory to ',baseDirListing(thisEntry).name])
                    tempdir=dir;
                    foundScans(thisdir).Filenames = tempdir(3).name;
                    % OK the letter at the end of the next line is
                    % crucially dependent on the way in which the dicoms
                    % are saved out
                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    %%%%%% CURRENTLY SET TO 'R' FOR FILES MR*, WHERE * IS
                    %%%%%% AN IMAGE NUMBER 1 - N
                    %%%%%% 
                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    foundScans(thisdir).Filenames = foundScans(thisdir).Filenames(1:find(foundScans(thisdir).Filenames=='R'));
                    foundScans(thisdir).DirName = baseDirListing(thisEntry).name;
                    foundScans(thisdir).Files = length(tempdir)-2;
                    disp([num2str(foundScans(thisdir).Files)])
                    header=dicominfo(tempdir(3).name);
                    % Place holding comment for DEBUG - Slices counted
                    % If this is wrong then we will end up with the wrong
                    % number of Volumes, so display the value.
                    foundScans(thisdir).Slices = header.Private_0021_104f;
                    disp('Slices per volume for this directory = '); disp(foundScans(thisdir).Slices); 
                    % Place holding comment for DEBUG - Volumes counted
                    foundScans(thisdir).Volumes = (length(tempdir)-2)/foundScans(thisdir).Slices;
                    disp('Number of Volumes = '); disp(foundScans(thisdir).Volumes);
                    % Currently, this is hard-coded. We should be more
                    % flexible in case we change the protocol name. Also
                    % note that Current YNiC implementation does not
                    % comform to the boolean below.
                    if strcomp(header.SeriesDescription,'fMRI')&foundScans(thisdir).Volumes>40 % Currently, this is hard-coded. We should be more flexible in case we change the protocol name.
                        foundScans(thisdir).Action = 'Functional';
                    else
                        foundScans(thisdir).Action = 'Nothing';
                    end
                    if strcomp(lower(header.SeriesDescription),'inplanes')
                        inplanedir = thisdir;
                    end
                    
                    foundScans(thisdir).Sequence = header.SeriesDescription;
                end
            catch
            end
            cd (baseDir)
        end
    end
    if not(inplanedir==0)
        foundScans(inplanedir).Action='Inplanes';
    else
        Usermessage='No Inplanes found';
    end 
    foundScans.Volumes
    foundScans=selectInitParameters(foundScans);
    foundScans.Volumes
    save UCSFPrepare foundScans baseDir;
else %if not scan the directory one would have to read the info from a previous run
    try
    load UCSFPrepare;
    catch
        error('Not detecting data, no UCSFPrepare.mat from older run found.');
    end
    foundScans=selectInitParameters(foundScans);
end

save UCSFPrepare foundScans baseDir;

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Recon all the functionals to 4dAnalyse
%%
for thisDir=1:length(foundScans)
    if strcmp(foundScans(thisDir).Action,'Functional')|...
            strcmp(foundScans(thisDir).Action,'RefFunc')
        filetoolook = [foundScans(thisDir).Filenames,'_4d.hdr'];
        thisOutFile = [baseDir,filesep,foundScans(thisDir).DirName,filesep,filetoolook];
        if ~exist(thisOutFile,'file');
            
            foundScans(thisDir)=Dicom2FourDAnalyze_MedCom_UCSF(foundScans(thisDir));
        else
            foundScans(thisDir).Filename4d=filetoolook;
            disp ([filetoolook,' found not creating it again']);
        end
        foundScans(thisDir).Filename4d=thisOutFile;
        foundScans(thisDir).lastfile=thisOutFile;
    end
end
datestr(now)
clear thisDir:
save UCSFPrepare;

     
        
        
            
            
 
save UCSFPrepare;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% WithinScanMotionCorrect
%%
% MCFLIRT lets you do this in one step. Note that the -mats option dumps
% each transform matrix to disk. TODO: After this finishes, we should plot
% the within scan motion in x,y,z, rx,ry,rz to make sure that it is
% sensible.


if motionInScan
    for thisScan=1:length(foundScans)
        if not(isempty(foundScans(thisScan).Filename4d));
            thisInFile=foundScans(thisScan).lastfile;
            thisOutFile=[thisInFile(1:end-4),'_mcf'];
            if ~exist([thisOutFile,'.img'],'file');
                outputMatDir=[thisInFile(1:end-4),'_mcf.mat'];

                if (exist(outputMatDir,'dir'))
                    disp('deleting existing withinscan transforms must be remiders of crash...');
                    system(['\rm -r ',outputMatDir]);
                end

                % Generate a directoryname for the within-scan matrices
                WithinScanDir=[foundScans(thisScan).Filename4d(1:end-4),'_mcf_withinScan'];
                % ABM - changed from a system call to an eval - check this
                % works
                evalstrx=['!FSLOUTPUTTYPE=ANALYZE mcflirt -in ',thisInFile,' -refvol 0 -stats -verbose 0 -mats ']; % omats sends the xform matrices to a directory called Filename.mat
                eval(evalstrx);     % We want to move the output directory to another name for
                % clarity
                system(['mv ',outputMatDir,' ',WithinScanDir]);
                disp(['wrote ',thisOutFile]);
            else
                disp(['found ',thisOutFile,', keeping it']);
            end
            foundScans(thisScan).lastfile=thisOutFile;
        end
    end
    save UCSFPrepare
    datestr(now)
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Between Scan MotionCorrect
%%
if motionBetween
    if motionInScan
        Reffunc=0;
        VolstoCorrect = [];
        %find out what to do
        for thisScan=1:length(foundScans)
            if strcmp(foundScans(thisScan).Action,'RefFunc');

                Reffunc=thisScan;
            elseif not(isempty(foundScans(thisScan).Filename4d));
                VolstoCorrect = cat(1,VolstoCorrect,thisScan);

            end %is functional
        end
        if Reffunc==0
            Reffunc=VolstoCorrect(1);
            VolstoCorrect=VolstoCorrect(2:end);
        else %motion Between but not within
            disp('Error! MotionCorrectBetween Scan can only be executed if withinscan is done before!')
        end
    end

    for thisScan=VolstoCorrect'
        %usage     flirt -in invol -ref refvol -out outvol -omat invol2refvol.mat -dof 6
        targetname = foundScans(thisScan).Filename4d;
        referencename = foundScans(Reffunc).Filename4d;
        invol = [targetname(1:end-4),'_mcf_meanvol.hdr'];
        refvol = [referencename(1:end-4),'_mcf_meanvol.hdr'];

        betweenmat=[targetname(1:end-4),'_mcf_meanvol_toRef'];
        %        [path,file,ext]=fileparts(betweenmat); %otherwise fsl writes the stuf deeeeeep into subdirs...
        %       betweenmat=[foundScans(thisScan).DirName,filesep,file];
        WithinScanDir=[foundScans(thisScan).Filename4d(1:end-4),'_mcf_withinScan'];

        %get the mat file between the scans
        evalStr=['!FSLOUTPUTTYPE=ANALYZE flirt -in ',invol,' -ref ',refvol,' -omat ',betweenmat,' -dof 6'];
        eval(evalStr);
        % Again, we should take a peek at the between scans motions at this
        % point...
        %

        % now combine the the betweenScan Matrix with the withinScan matrix
        % inFileRoot=[baseDir,filesep,foundScans(thisScan).DirName,filesep,...
        %        targetname(1:end-4),'_mcf.mat',filesep,'MAT_'];
        outDir=[targetname(1:end-4),'_mcf_fullXForm'];
        if (~exist(outDir,'dir'))
            mkdir(outDir);
        end

        outFileRoot=[outDir,filesep,'MAT'];

        status=fsl_concatSingleXFormToDir(betweenmat,[WithinScanDir,filesep,'MAT'],outFileRoot);
        %Now combine the two transforms
        %applyxfm4d input volume> <ref volume> <output volume>
        %example:
        %  /raid/MRI/toolbox/FSL/fsl/bin/applyxfm4D E5217S6I_4d.hdr E5217S6I_4d_mcf_meanvol.hdr E5217S6I_4d_out.hdr E5217S6I_4d_mcf_fullXForm -fourdigit
        inVol=[foundScans(thisScan).Filename4d];
        outVol=[foundScans(thisScan).Filename4d(1:end-4),'_fullMotionCorr'];
        if ~exist([outVol,'.hdr'],'file')
            evalStr=['!FSLOUTPUTTYPE=ANALYZE applyxfm4D ',inVol,' ',refvol,' ',outVol,' ',outDir,' -fourdigit'];
            disp([' writing a full motioncorrected for scan ',foundScans(thisScan).Filename4d]);
            trashstring=evalc(evalStr);
        else
            disp([' found ',outVol,' keeping it']);
        end
        foundScans(thisScan).lastfile=outVol;

    end
    datestr(now)
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% make the directories needed
%%

cd (baseDir)
if doMLR
    !mkdir RawDicom
    !mkdir Inplane
    !mkdir Volume
    !mkdir Gray
end

save UCSFPrepare 

% ABM - debugging stuff - problem is setting the data type
% disp(foundScans); disp(SessionName); disp(subjectName);


status=mrInitRetFromFSL(foundScans,SessionName,subjectName);

if blockedData
    mrvista('inplane');
    inplane=getSelectedInplane;
    inplane=computeMeanMap(inplane,0);
    inplane=computeCorAnal(inplane,0);
    inplane = selectDataType(inplane,2);
    inplane=computeMeanMap(inplane,0);
    inplane=computeCorAnal(inplane,0);
%    closeInplaneWindow();
    datestr(now)
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CleanUp remove the analyze files
%%

if doCleanUp
    for thisDir=1:length(foundScans)
        if strcmp(foundScans(thisDir).Action,'Functional')
            madefiles=foundScans(thisDir).Filename4d;
            evalStr=['!rm -r ',madefiles(1:end-4),'*']
            eval(evalStr);
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CleanUp move the Dicom Files to a zip archive
%%

datestr(now)
if doPackDicom
    for thisDir=1:length(foundScans)
        if strcmp(foundScans(thisDir).Action,'Functional')
            cd (baseDir);
            cd (foundScans(thisDir).DirName);
            evalStr=['! tar czf ',foundScans(thisDir).Filenames,'.tgz ',foundScans(thisDir).Filenames,'*.DCM'];
            eval(evalStr);
            evalStr=['!rm ',foundScans(thisDir).Filenames,'*.DCM']
            eval(evalStr);
        end
    end
end
clx

disp('prepareUCSF successfull, enjoy!');
