%function [Siemens dir_list] = sort_Siemens_Data()

% function sort_Siemens_Data scans the current folder for dicom files
% that have filenmaes consistent with Siemens acquisitions and then sorts
% them into folders for each series and names them with the YNiC
% convention.

%Amended 3/08/07 - AG .. altered for YNiC & Holloway data processing stream
%

clear all;


Sess = 0;
scan_dir = pwd;
disp(['Scanning ',scan_dir,' for Siemens Dicom files']);
!rm .DS_Store;
!rm AccuImage.dir;
file_list = dir;
created_inplane_from_first_fMRI_vol = 0; %flag to hold state of path to pass to create_inplane_from_first_fMRI_vol.m

file_list = file_list(3:length(file_list));
% use the string HOLLOWAY_TONY as the identifyer of the Dicoms


f_count = 1;

for j=1:length(file_list)
    if isdir(file_list(j).name)
    else
        corr_file_list(f_count) = file_list(j);
        f_count = f_count + 1;
    end
end



file_list = corr_file_list;


is_dicom = strfind(file_list(1).name, 'HOLLOWAY_TONY'); %%% Your personal sequence identifier needs to go here

if is_dicom
    disp(['Found file(s) with HOLLOWAY_TONY in the name e.g. ',file_list(1).name])
    disp(['Now finding series and sorting them into folders.'])

    for i = 1:length(file_list);
        r = dicominfo(file_list(i).name);

        if r.SeriesDescription(1:5)=='local'|r.SeriesDescription(1:5)=='ep2d_' %%% series desriptor first 5 letters
            %disp('IS')
            series_id = file_list(i).name(is_dicom + 14: is_dicom + 15);
            if series_id(2) == '.'
                file_list(i).series = str2num(series_id(1));
                series(i) = str2num(series_id(1));
                volume_id = file_list(i).name(is_dicom + 16: is_dicom + 18);
                if volume_id(2) == '.'
                    file_list(i).vol = str2num(volume_id(1));
                    volume(i) = str2num(volume_id(1));
                elseif volume_id(2) == '.'
                    file_list(i).vol = str2num(volume_id(1:2));
                    volume(i) = str2num(volume_id(1:2));
                else
                    file_list(i).vol = str2num(volume_id(1:3));
                    volume(i) = str2num(volume_id(1:3));
                end
            else
                file_list(i).series = str2num(series_id);
                series(i) = str2num(series_id);
                volume_id = file_list(i).name(is_dicom + 17: is_dicom + 19);
                if volume_id(2) == '.'
                    file_list(i).vol = str2num(volume_id(1));
                    volume(i) = str2num(volume_id(1));
                elseif volume_id(2) == '.'
                    file_list(i).vol = str2num(volume_id(1:2));
                    volume(i) = str2num(volume_id(1:2));
                else
                    file_list(i).vol = str2num(volume_id(1:3));
                    volume(i) = str2num(volume_id(1:3));
                end
            end
        else
            %disp('IS NOT')

        end
    end
end


disp('Processing the following series:')
unique_series_to_process = unique(series);
unique_series_to_process = unique_series_to_process(2:end) %remove '0' series

for j = 1:length(unique_series_to_process)
    m=unique_series_to_process(j)
    indexit = find(series == m);
    %series.name = file_list(indexit).name;


    if length(indexit) == 3
        Sess = Sess + 1;
        created_inplane_from_first_fMRI_vol = 0;
        Sess_path = ['Session',num2str(Sess)]
        evalstr = ['!mkdir ',Sess_path];
        eval(evalstr);
        scout_path = [Sess_path,filesep,'SS'];
        evalstr = ['!mkdir ',scout_path];
        eval(evalstr);
        move_file_list = [file_list(indexit(1)).name,' ',file_list(indexit(2)).name,' ',file_list(indexit(3)).name];
        evalstr = ['!cp ',move_file_list,' ',scout_path];
        eval(evalstr);

    elseif length(indexit) >50 & length(indexit) <150 % this is a lame conditional to find functionals
        if Sess == 0;
            Sess = 1;
            Sess_path = ['Session',num2str(Sess)]
            evalstr = ['!mkdir ',Sess_path];
            eval(evalstr);
        end
        f_path = [Sess_path,filesep,num2str(m+100),'_fMRI']

        mkdir_str = ['!mkdir ',f_path];
        eval(mkdir_str);
        for k = 1:length(indexit)
            vol_index = find(volume(indexit) == k);
            vol_index = vol_index + indexit(1) - 1;
            % OK, now we have the index
            mosaic_file = file_list(vol_index).name;
            disp(mosaic_file);
            hdr = dicominfo(mosaic_file);
            data = dicomread(mosaic_file, hdr);
            noMosaics = siemensHeaderParams(hdr, 'NumberOfImagesInMosaic');
            noMosaics = str2num(noMosaics);
            imMatrix = double(hdr.AcquisitionMatrix);
            imMatrix( imMatrix==0 ) = []; imMatrix = imMatrix(:)'; % slightly wierd syntax to handle differences between spm_dicom_header & dicominfo

            % create empty volume array
            sliceit = zeros( [ imMatrix ] );
            disp(size(sliceit))

            % get number of images in rows & columns
            imDim = double([hdr.Rows hdr.Columns])./imMatrix;

            % temp stuff just to check
            myval = 0.5*(max(double(data(:))));
            tmp = data;

            for i = 1:noMosaics

                nr = rem(i, imDim(1));
                if ~nr; nr = imDim(1); end

                nc = ceil(i/imDim(1));

                sliceit(:,:) = data( imMatrix(2)*(nc-1)+1:nc*imMatrix(2) , imMatrix(1)*(nr-1)+1:nr*imMatrix(1) );
                sliceit = uint16(sliceit);
                new_name = sprintf('MR%06d', i + (k-1)*noMosaics);
                new_name = [f_path,filesep,new_name];
                evalstr = ['dicomwrite(sliceit, ''',new_name,''')'];
                eval(evalstr);
                disp(['writing slice ',new_name]);
                %tmp(  imMatrix(2)*(nc-1)+1:nc*imMatrix(2) , imMatrix(1)*(nr-1)+1:nr*imMatrix(1)) = myval;
                %imagesc(tmp); disp(i); pause(0.4);
            end

            if created_inplane_from_first_fMRI_vol == 0 %create an inplane from this first volume .. pass the path and number of slices to create_inplane_from_first_fMRI_vol.m
                create_inplane_from_first_fMRI_vol(f_path, noMosaics)
                created_inplane_from_first_fMRI_vol = 1;
            else
            end

            % re-order slices %%%%%%%%%%%%%%%%%%%%%check this!!!!!!!!!!!!!!
            %vol = vol(:,:, [noMosaics:-1:1]);
        end
    else
    end
end
    
    
