function rxToggle(rx);
% For mrRx: quickly toggle between a prescribed slice image and 
% a reference slice for comparison.
%
% rxToggle(rx);
%
%
% ras, 01/06.
if ~exist('rx', 'var') | isempty(rx), 
    cfig = findobj('Tag', 'rxControlFig');
    rx = get(cfig, 'UserData');
end

[interp ref] = rxGetComparisonImages(rx);

nToggles = 3; % # of times to alternate b/w interp and ref images

if ishandle(rx.ui.compareAxes)
    axes(rx.ui.compareAxes)
else
    figure('Name', 'mrRx: rxToggle');
end 

rng = [min(interp(:)) max(interp(:))];

for n = 1:nToggles
    imshow(ref, rng);
    pause(0.15);
    imshow(interp, rng);
    pause(0.15);
end

return
