function rx = rxOpenCompareFig(rx);
% rx = rxOpenCompareFig(rx);
%
% Open a window for the compareerence  volume.
%
% ras 02/05

rx.ui.compareFig = figure('Color', 'w',...
                      'Name', 'mrRx Compare Interp/Ref',...
                      'Units', 'Normalized',...
                      'Position',  [.02 .15 .3 .4],...
                      'MenuBar', 'none',...
                      'NumberTitle', 'off',...
                      'ButtonDownFcn', 'zoom',...                        
                      'CloseRequestFcn', 'closereq; rxRefresh;');
                  
rx.ui.compareAxes = axes('Position', [0.05 .15 .9 .85]);

% make a popup for selecting the comparison method
methods = {...
           'Overlay (red / blue)' ...
           'Subtract' ...
           'Checkerboard' ...
           };
cb = 'rxRefresh;';
rx.ui.comparePopup = uicontrol('Style', 'popup', ...
                                'Units', 'Normalized',...
                                'Position', [.27 .02 .5 .05],...
                                'String', methods,...
                                'BackgroundColor', get(gcf,'Color'),...
                                'Value', 1, 'Callback', cb);
uicontrol('Style', 'text', 'String', 'Comparison Method:',...
          'Units', 'Normalized', 'Position', [.02 0 .25 .08],...
          'BackgroundColor', get(gcf,'Color'));
      

% add sliders for setting rx / ref brightness in the comparison
rx.ui.rxCompareSlider = uicontrol('Style', 'slider', ...
                                'Units', 'Normalized', ...
                                'Position', [.6 .18 .38 .03], ...
                                'Min', 0, 'Max', 1, ...
                                'BackgroundColor',get(gcf,'Color'), ...
                                'Tag', 'rxCompareSlider', ...
                                'Value', .3, 'Callback', cb);
uicontrol('Style', 'text', 'String', 'Rx alpha:', 'FontSize', 9, ...
          'HorizontalAlignment', 'left', ...
          'Units', 'Normalized', 'Position', [.45 .18 .14 .03], ...
          'BackgroundColor', get(gcf,'Color'));
      
rx.ui.refCompareSlider = uicontrol('Style', 'slider', ...
                                'Units', 'Normalized', ...
                                'Position', [.6 .12 .38 .03], ...
                                'Min', 0, 'Max', 1, ...
                                'BackgroundColor',get(gcf,'Color'), ...
                                'Tag', 'refCompareSlider', ...
                                'Value', .3, 'Callback', cb);
uicontrol('Style', 'text', 'String', 'Ref alpha', 'FontSize', 9, ...
          'HorizontalAlignment', 'left', ...
          'Units', 'Normalized', 'Position', [.45 .12 .14 .03], ...
          'BackgroundColor', get(gcf,'Color'));
          
% make a 'toggle' button to quickly switch between rx and ref images
rx.ui.compareToggle = uicontrol('Style', 'pushbutton', ...
                                'Units', 'Normalized',...
                                'Position', [.82 .02 .15 .05],...
                                'String', 'Toggle',...
                                'BackgroundColor', get(gcf,'Color'),...
                                'Callback', 'rxToggle;');
          
% add a menu to set preferences
rxComparePrefsMenu(gcf);      
      
% by default, we'll show the comparison statistics     
rx = rxShowStats(rx,1);  

return
