function [compareImg, rng, ttltxt] = rxCompare(A,B,method);
%
% [compareImg, rng, ttltxt] = rxCompare(A,B,method);
%
% Compare two images (generally an interpolated 
% slice and reference slice) and generate an
% image reflecting the similarity between the
% two, using the selected method (an integer).
%
% Methods:
%
%
%            1) Subtract
%            3) Overlay (red / green)
%            4) Checkerboard
%
%
%
% 02/05 ras.
compareImg = [];
rng = [];

switch method
               
    case 1, % color overlay (red/blue)
        compareImg = A;
        compareImg(:,:,2) = B;
        compareImg(:,:,3) = B;
        rng = [0 1];
        ttltxt = 'Red: Interpolated; Blue-Green: Reference';

    case 2, % subtract
        compareImg = A-B;
        rng = [-1 1];
        ttltxt = 'Interpolated Minus Reference';
        
    case 3, % make checkerboard
        compareImg = regMosaic(A,B,10);
        rng = [min(compareImg(:)) max(compareImg(:))];
        ttltxt = 'Interpolated / Reference Mosaic';
        
end

% now check if stats are requested,
% and if so display them:
hstats = findobj('Tag','quantifyMenu');

if isempty(hstats)
    showStats = 0;
else
    showStats = isequal(get(hstats(end),'Checked'),'on');
end

if showStats
    % (I only do this now, so the code could
    % conceivably be used outside mrRx):
    cfig = findobj('Tag','rxControlFig');
    rx = get(cfig,'UserData');
    
    % test for valid text fields
    if isfield(rx.ui,'compareStats')
        if ishandle(rx.ui.compareStats.corrcoefVal) 
            % compute correlation coefficient
            R = corrcoef(A(:),B(:));
            set(rx.ui.compareStats.corrcoefVal,'String',num2str(R(2)));            
            
            % compute Root Mean-Squared Error
            RMSE = sqrt(mse(A,B));
            set(rx.ui.compareStats.rmseVal,'String',num2str(RMSE));
        else
            rx.ui = rmfield(rx.ui,'compareStats');
        end
    end
end

return
