function g2vMap = mrmMapGrayToVertices(grayNodes,vertexCoords, mmPerVox)
%
% g2vMap = mrmMapGrayToVertices(grayNodes,vertexCoords, mmPerVox)
%
% Finds a map between all gray nodes and the mesh vertices
% To see the  coordinate of a mesh  node nearest to a gray node, we
% can use
%    
%      initVertices(1:3,g2vMap(idx))
%
% HISTORY:
%  2004.03.26 ARW wade@ski.org. Based on RFD's routine mrmVerticesToGray

if ieNotDefined('mmPerVox'), error('Voxel size (mm per vox) is required.'); end;

% The gray coordinates are in voxels in the vAnatomy file.  This scales
% them into real physical (mm) coordinates.  And transposes them.
grayCoords = grayNodes([1,2,3], :);
grayCoords = [grayCoords(1,:).*mmPerVox(1); ...
        grayCoords(2,:).*mmPerVox(2); ...
        grayCoords(3,:).*mmPerVox(3) ]';

% Transposes these mesh coordinates, which were already built in real
% physical coordinates.  
% Major comments needed here.
vertexCoords = vertexCoords' + 1;

% Mask out non-layer 1 nodes so that they are not found
%grayCoords(find(grayNodes(6,:)~=1),:) = -9999;

% Some day, this will be better.  Even sooner, the logic will be commented.
%v2gMap = zeros(size(vertexCoords(1,:)));
g2vMap = zeros(1,length(grayCoords)); % One entry for each gray node


[goodLocInd, loc] = ismember(round(grayCoords/4),round(vertexCoords/4) , 'rows');
fGoodLocs=find(goodLocInd);

g2vMap(fGoodLocs) = loc(fGoodLocs);

[goodLocInd, loc] = ismember(round(grayCoords/2),round(vertexCoords/2), 'rows');
fGoodLocs=find(goodLocInd);

g2vMap(fGoodLocs) = loc(fGoodLocs);
[goodLocInd, loc] = ismember(grayCoords,vertexCoords, 'rows');
fGoodLocs=find(goodLocInd);

g2vMap(fGoodLocs) = loc(fGoodLocs);

g2vMap = int32(g2vMap);

return;
