function serverStarted = mrmCheckServer(host)
%
%     serverStarted = mrmCheckServer(host)
%
% Author: Wandell
% Purpose:
%   Test whether the server has been started.  There should be a way to
%   test without creating a new window.  But I am not sure how.
%   
% mrmCheckServer

if ieNotDefined('host') host = 'localhost'; end

stat = mrMesh(host, 999, 'refresh'); 

% If the status is not -1000, the window opened and the server is there.
% So, close the window and return.
if stat ~= -1000 
    serverStarted = 1;
    mrMesh(host,999,'close');
    return;
else
    serverStarted = 0;
end

return;