function [img, mmPerPix, vSize, filename, formatStr] = loadVolumeDataAnyFormat(filename)

if ~exist('filename', 'var')
   filename = '';
end
img = [];
mmPerPix = [];
vSize = [];

% if filename is empty, get the filename and path with a uigetfile
if isempty(filename)
	[fname, fpath] = uigetfile({'*.dat','mrGray vAnatomy (*.dat)';'*.hdr','Analyze 7.5 format (*.hdr)'}, 'Select a volume file...');
   filename = [fpath fname];
   if fname == 0  % user cancelled
      return;
   end
end
[p,f,ext] = fileparts(filename);

if(strcmp(lower(ext),'.dat'))
    [img, mmPerPix, vSize] = readVolAnat(filename);
    formatStr = 'vanat';
elseif(strcmp(lower(ext),'.hdr'))
    [img, mmPerPix, hdr] = loadAnalyze(filename);
    formatStr = 'analyze';
%     % to make analyze data the same orientation as vAnatomy, we swap dims and then 
%     % flip along the new y and x.
%     % Note that we assume Analyze orientation code '0'- transverse, unflipped. 
%     img = permute(img,[3,1,2]);
%     mmPerPix = [mmPerPix(3),mmPerPix(1),mmPerPix(2)];
%     % flip each slice ud (ie. flip along matlab's first dimension, which is our x-axis)
%     for(jj=1:size(img,3))
%         img(:,:,jj) = flipud(squeeze(img(:,:,jj)));
%     end
%     % flip each slice lr(ie. flip along matlab's second dimension, which is our y-axis)
%     for(jj=1:size(img,3))
%         img(:,:,jj) = fliplr(squeeze(img(:,:,jj)));
%     end
    vSize = size(img);
else
    error('Unknown file format!');
end

return;