function [defX,defY,defZ] = mrAnatInvertSn(sn)
%
%  [defX,defY,defZ] = mrAnatInvertSn(sn)
%
% Inverts and SPM-style spatial normalization deformation ('sn').
%
% To use the inverse deformation:
% acPcCoords = sn.VF.mat*[imgCoords 1]'; % Or, get from default bb
% defCoords = inv(sn.VG.mat)*acPcCoords;
%
% HISTORY:
% 2005.01.25 RFD: wrote it.

if(~exist('spm_invdef','file'))
    spmDir = fileparts(which('spm_normalise'));
    p = fullfile(spmDir,'toolbox','Deformations');
    disp(['Adding spm deformation toolbox path (' p ')']);
    addpath(p);
end
d = single(mrAnatSnToDeformation(sn));
% 4th arg is 4x4 xform from mm to voxels in the coordinate frame of the inverse deformation field
% 5th arg is xform from voxels to mm in the coordinate frame of the forward deformation field
[defX,defY,defZ] = spm_invdef(d(:,:,:,1), d(:,:,:,2), d(:,:,:,3), sn.VF.dim(1:3), inv(sn.VF.mat), sn.VF.mat);
return;