function [img, clipVals] = mrAnatHistogramClip(img, lowerClip, upperClip, rescaleFlag)
%
% img = mrAnatHistogramClip(img, lowerClipLevel, upperClipLevel, rescaleFlag)
%
% Clips the input array values (img) so that the range of values will be
% between the pixel-count proportions specified by lowerClip and upperClip.
% Eg, if lowerClip = 0.20 and upperClip = 0.98, then the values in img will
% be clipped so that the lowest value is that of the 20th percentile of the
% original values and the upper value is that of the 98th percentile.
%
% HISTORY:
% 2004.11.05 RFD: wrote it.

if(~exist('rescaleFlag','var') | isempty(rescaleFlag))
    rescaleFlag = 1;
end

[count,value] = hist(img(:),256);
upperClipVal = value(min(find(cumsum(count)./sum(count)>=upperClip)));
img(img>upperClipVal) = upperClipVal;
lowerClipVal = value(max(find(cumsum(count)./sum(count)<=lowerClip)));
if(isempty(lowerClipVal)) lowerClipVal = value(1); end
img(img<lowerClipVal) = lowerClipVal;
if(rescaleFlag)
    img = img-lowerClipVal;
    img = img./(upperClipVal-lowerClipVal);
end
clipVals = [lowerClipVal upperClipVal];

return
