function writeGrayGraph(filename,nodes, edges, vSize)
% 
%    writeGrayGraph(filename,mrLnodes, mrLedges, vSize)
% 
% AUTHOR:  Maher Khoury
% DATE:    08/20/1999
% PURPOSE:
%    Use mrLoadRet nodes and edges to write a gray matter file to be read by mrGray
% 
% ARGUMENT:
%  filename - name of gray graph file to be read by mrGra
% 	nodes		- 8xN array of Nx(x,y,z,num_edges,edge_offset,layer,dist,pqindex).
% 	edges		- 1xM array of node indices.  The edge_offset of
%    			  each node points into the starting location of its set
%    			  of edges. where N, M are the number of nodes, edges in the graph.
%	vSize		- Size of the original volume of data containing the anatomicals
%
% BW:  12.1.00
%   Various changes.
%     mrGnodes distinguished from mrLnodes 
%     mrGedges distinguished from mrLedges
%     mrGnodes was written out with only 6 rows, when 8 is the usual size of nodes
%

disp('Caution:  writeGrayGraph not extensively tested yet.')

% mrGray on all machines writes out using ieee big endian
% format.  So, we must always open our files that way.
% 
fid = fopen(filename,'w','b');

% [xsize, ysize, zsize]; [cols, rows, planes].
sizes = [vSize(2), vSize(1), vSize(3)];

% Write out xsize, ysize, zsize.
fwrite(fid, sizes, 'int');
clear sizes;

% Write header.
sizes(1) = size(mrLnodes,2);
sizes(2) = size(mrLedges,2);
mrGnodes = zeros(8,sizes(1));

% Write out number of nodes and edges.
fwrite(fid, sizes, 'int');

% C / Matlab offset issue  ??!?!
mrGnodes(1:3,:) = mrLnodes(1:3,:)  - 1;
mrGnodes(5,:) = mrLnodes(5,:)  - 1;

% Write nodes.
fwrite(fid, mrGnodes(1:8,:), 'int');

% C / Matlab offset issue  ??!?!
mrGedges = mrLedges - 1;

% Read edges.
fwrite(fid, mrGedges, 'int');


fclose(fid);

return;