function class = writeClassFile(class,filename,voiInfo);
% 
%  class = writeClassFile(class,filename);
%
% AUTHOR:  Wandell
% DATE:    10.17.97
% PURPOSE: 
%   Write out the information in a mrGray classification file.
%   The output file is in a format that can be read by mrGray.
% 
% ARGUMENTS:
% 
%    class:  The classification data structure.  (Built by readClassFile).
% filename:  The output filename
% 
% SEE ALSO
%   readClassFile
%

% DEBUG:
% Read in a class file, write it back out, and check thend read
% it back in again.
% 
% class = readClassFile('rightCalc.class');
% filename = 'test.class'
% writeClassFile(class,filename);
% tclass = readClassFile(filename);
% 
% Check class.header by hand.
% max(abs(tclass.data(:) - class.data(:)))
% class.header.params - tclass.header.params
% class.header.voi - tclass.header.voi
% class.header.vSize - tclass.header.vSize

% Open the file
% 
fprintf('Writing class file:  %s\n',filename);
fp = fopen(filename,'w');

% Convert Matlab 1-indexing to C 0-indexing
%class.header.voi = class.header.voi-1;

% Write header information
% 
fprintf(fp, 'version= %d\n', '2');%class.header.version);
fprintf(fp, 'minor= %d\n', '1');%class.header.minor);

fprintf(fp, 'voi_xmin=%d\n',voiInfo.zMin);
fprintf(fp, 'voi_xmax=%g\n',voiInfo.zMax);
fprintf(fp, 'voi_ymin=%d\n',voiInfo.yMin);
fprintf(fp, 'voi_ymax=%d\n',voiInfo.yMax);
fprintf(fp, 'voi_zmin=%d\n',voiInfo.xMin);
fprintf(fp, 'voi_zmax=%d\n',voiInfo.xMax);

fprintf(fp, 'xsize=%d\n',voiInfo.zSize);
fprintf(fp, 'ysize=%d\n',voiInfo.ySize);
fprintf(fp, 'zsize=%d\n',voiInfo.xSize);

csf_mean   = 1%class.header.params(1);
gray_mean  = 5%class.header.params(2);
white_mean = 255%class.header.params(3);
stdev      = 1%class.header.params(4);
confidence = 0.93%class.header.params(5);
smoothness = 1%class.header.params(6);

% 
fprintf(fp, 'csf_mean=%g\n',csf_mean );
fprintf(fp, 'gray_mean=%g\n',gray_mean);
fprintf(fp, 'white_mean=%g\n',white_mean);
fprintf(fp, 'stdev=%g\n',stdev);
fprintf(fp, 'confidence=%g\n',confidence);
fprintf(fp, 'smoothness=%d\n',smoothness);

% Done writing the header

% Initialize the classification volume
im2 = ones(voiInfo.zSize, voiInfo.ySize, voiInfo.xSize);

% Take the data in the VOI and copy them into the 
% classification volume
im2( ...
    voiInfo.zMin:voiInfo.zMax, ...
    voiInfo.yMin:voiInfo.yMax, ...
    voiInfo.xMin:voiInfo.xMax) = ... 
    class(voiInfo.zMin:voiInfo.zMax, ...
    voiInfo.yMin:voiInfo.yMax, ...
    voiInfo.xMin:voiInfo.xMax);

% Write the data into the file and return
% 
cnt = fwrite(fp,class,'uchar');
fclose(fp);

return;

% 
% End of writeClassFile

