function mrVista(windowType, localAnatomy)
%Open the mrLoadRet (mrVista) package with a specific window type 
% 
%  mrVista(windowType, localAnatomy)
%
% This script opens windows of several types:
%    'inplane','montage','flat','volume','gray',3view' 
%
% You can also specify a particular vAnatomy file.  This is handy when you
% are working in a place where the X:\anatomy folder is unavailble.
%
% mrVista replaces the mrLoadRet script.  That script only opens an inplane
% window.  
%
% Example
%   mrVista('flat')
%   myAnat = 'C:\u\brian\Matlab\mrDataExample\pn-anatomy\vAnatomy.dat';
%   mrVista('inplane',myAnat);
%   mrVista('gray',myAnat');
%
% REVISIONS:
% ras, 12/05 -- made 'inplane' call up the montage window. I see no
% reason not to replace the old window with the montage one; it just adds
% an extra slider for # of slices, and replaces the anat max/min with
% brightness and contrast controls. Also, disabled the setting of 
% vANATOMYPATH: it's unnecessary for inplanes, and for volumes, should
% be done when opening that window. 
if ieNotDefined('windowType'), windowType = 'inplane'; end

% Define global variables and structures for this routine
mrGlobals;

% Also run mrGlobals in the base space so that the globals are visible.
evalin('base','mrGlobals') ;

% Check Matlab version number
% Change list after testing Matlab upgrades
expectedMatlabVersion = {'6' '6.1' '6.5' '6.5.1' '6.5.2' '7.0' ...
                         '7.0.1' '7.0.4' '7.1'};  
version = ver('Matlab');
matlabVersion = version.Version;        
if ~ismember(matlabVersion, expectedMatlabVersion);    % (matlabVersion ~= expectedMatlabVersion)
    str = sprintf('Matlab version %s not on supported list (mrVista %s).', ...
        matlabVersion, num2str(mrLoadRetVERSION));
    myWarnDlg(str);
else
    fprintf('mrLoadRet version: %s\nMatlab version: %s\n',num2str(mrLoadRetVERSION),version.Version);
end

if (strcmp(matlabVersion,'7.0.4'))
    disp('Turning off Java in 7.0.4 figures to fix slider bug');
    feature('javafigures',0);
end

% Load mrSESSION structure
loadSession;

% Set HOMEDIR 
HOMEDIR = pwd;
% if ieNotDefined('localAnatomy'), vANATOMYPATH = getvAnatomyPath(mrSESSION.subject); 
% else                             vANATOMYPATH = localAnatomy;
% end


% open the appropriate window
switch lower(windowType)
   case {'inplane', 'montage'}
       openMontageWindow;
   case {'flat'}
       openFlatWindow;
   case {'volume'}
       openVolumeWindow;
   case {'gray'}
       openGrayWindow;
   case {'3view'}
       open3ViewWindow;
   otherwise
       error('Unknown window type.');
end


% Clean up
clear expectedMatlabVersion version matlabVersion

return;
