function view = meshDelete(view, meshNum);
% 
%   view = meshDelete(view, meshNum);
%
%Author: RFD
%   Deletes specified meshes from the mesh file.  
%   If meshNum = inf, all meshes are deleted.
%
% 2004.01.12 BW  Added viewSet/viewGet, removed old file management
% comments.  Renamed from DeleteMesh.
% 
% Moved most of the function into viewSet.

if ieNotDefined('meshNum')
    meshNames = viewGet(view,'meshnames');
    [meshNum,ok] = listdlg('PromptString', 'Select meshes to delete:', ...
        'SelectionMode', 'multiple', ...
        'ListString', meshNames);
    if(ok~=1 | isempty(meshNum))
        return;
    end
end

if isinf(meshNum),     % Delete them all
    meshNum = 1:viewGet(view,'numberofmeshes');
end
view = viewSet(view,'deleteMesh',meshNum);

return;