function [dataMaskIndices,data,cmap,dataRange,phaseFlag] = meshCODM(view)
%   [dataMaskIndices, dataOverlay, cmap, dataRange, phaseFlag] = meshCODM(view)
%
%
% Author: Dougherty/Ress
% Purpose:
%    Build dataMask, dataOverlay and colormap info for 3D window data.
%
% Indices into both of these correspond to view.nodes indices,
% which is how the functional data are index in the gray view. For the
% functional data, we basically just pull the data out and put it in the
% colorOverlay.
%
% The tricky part is building the dataMask, which tells us which part of
% colorOverlay to show.
%
% Re-written by BW several times.  More clarity still needed.
% ras, 02/04: fixed to be reasonable about parameter maps. For instance, if
% a param map value is == the max win value, it shouldn't be excluded.
% Also, no longer matters if there's a co, amp, or ph map assigned if we're
% in map mode (all my event-related stuff is like this).
% 09/2005 SOD: added a flag which tells whether the data is
% phase-data (circular) or not.

% Table of standard colors (for ROIs).  Should be separate routine.
[stdColVals,stdColLabs]  = meshStandardColors;

scan = viewGet(view,'currentscan');
dataMaskIndices = zeros(1,viewGet(view,'numberofnodes'));

% This code finds the node locations whose values are within the range of
% the sliders.  These are indicated by the entries of dataMaskIndices.
% These are determined for the display data here.  If we are in anatomy
% mode, though, they are determined from the ROIs in a different way.  See
% below.
% The code is oddly organized.  We should deal with anat, co, ph, amp and
% map separately.  As it stands, the different variables are all
% interleaved.
if ~strcmp(view.ui.displayMode, 'anat')

    % Get limits from sliders, find in-range voxels:
    cothresh = viewGet(view,'cothresh');       %getCothresh(view);
    phWindow = viewGet(view,'phasewindow');    %getPhWindow(view);
    mapWindow = viewGet(view,'statmapwindow'); %getMapWindow(view);

    % Determine whether the data are loaded?
    valid = ones(1, viewGet(view,'ncoords'));  %size(view.coords,2));
    coOK = ~isempty(viewGet(view,'co')) | ~isempty(viewGet(view,'map')); % maps count too!
    if coOK, coOK = ~isempty(viewGet(view,'scanco',scan)); end  % view.co{scan}
    if coOK
        co = viewGet(view,'scanco',scan);
        ph = viewGet(view,'scanphase',scan);
        map= viewGet(view,'mapn',scan);

        valid = valid & (co >= cothresh);
        if (phWindow(2)>phWindow(1))
            valid = valid & (ph <= phWindow(2));
            valid = valid & (ph >= phWindow(1));
        else
            valid = valid & (ph <= phWindow(2));
            valid = valid | (ph >= phWindow(1));
        end

        if (~isempty(map))
            if (mapWindow(2)>mapWindow(1))
                valid = valid & (map <= mapWindow(2));
                valid = valid & (map >= mapWindow(1));
            else
                valid = valid & (map <= mapWindow(2));
                valid = valid | (map >= mapWindow(1));
            end
        end
    end
    
    if strcmp(view.ui.displayMode, 'amp')
        data = viewGet(view,'scanamp',scan);
        if coOK
            valid = valid & (data <= mapWindow(2));
            valid = valid & (data >= mapWindow(1));
        end
    elseif isequal(view.ui.displayMode,'map')
        data = viewGet(view,'scanmap',scan);

        % 13-Jul-2005 SOD: In order to allow thresholding the 'map'
        % by the coherence (or phase), ie all limits from sliders,
        % I commented out the resetting line.
        %  valid = ones(1, viewGet(view,'ncoords'));  % resetting
        if ~isempty(data)
            if (mapWindow(2)>mapWindow(1))
                valid = valid & (data <= mapWindow(2));
                valid = valid & (data >= mapWindow(1));
            else
                valid = valid & (data <= mapWindow(2));
                valid = valid | (data >= mapWindow(1));
            end

        end
        dataMaskIndices = find(valid);
    end
    if coOK
        valid = find(valid);
        dataMaskIndices = valid;
    end
end

% 09/2005 SOD: Later on the data may get smoothed
% (meshColorOverlay.m), this smoothing should be done differently
% depending whether the data is phase-data (circular data) or not.
% So we need to have a flag which tells it what kind of data it
% is. Alternatively we could get this info from dataRange since
% phase-data will range from [0 2*pi]. But the may not be correct in the
% rare case that non-phase-data has the same [0 2*pi] range.
phaseFlag = 0;

switch view.ui.displayMode
    case {'co','coherence'}
        if coOK
            cmap = viewGet(view,'coherenceMap');
            data = co;
            dataRange = [0, 1];
        end
    case {'ph','phase'}
        if coOK
            cmap = viewGet(view,'phaseMap');
            data = ph;
            dataRange = [0, 2*pi];
            phaseFlag = 1;
        end
    case 'amp'
        if coOK
            mnv = min(data);
            mxv = max(data);
            cmap = viewGet(view,'ampMap');
            data = (data-mnv)/(mxv-mnv);
            dataRange = mapWindow;
        end
    case {'map','statisticalmap'}
        mapMode = viewGet(view,'mapMode');
        numGrays = mapMode.numGrays;
        cmap = round(view.ui.mapMode.cmap(numGrays+1:end,:) * 255)';
        if isequal(mapMode.clipMode,'auto')
            dataRange = mapWindow;
        else
            dataRange = mapMode.clipMode;
        end
    case {'anat','anatomy'}
        data = [];
        dataMaskIndices = [];
        dataRange = [];
        cmap = [];
    otherwise
        error('Unknown display mode.');
end

dataMaskIndices = unique(dataMaskIndices);
return;





% Older, commented-out code:
% ROIs are handled as a special case
% nROIs = length(view.ROIs);
% % Substitute the ROI color for appropriate nearest neighbor vertices
% for iR=1:nROIs
%     roi = view.ROIs(iR);
%     [junk,nodeInds] = ismember(roi.coords', view.nodes([2,1,3],:)', 'rows');
%     nodeInds = nodeInds(nodeInds>0);
%     % We can now accept roi.color as a vector (of RGB values) or as
%     % the original character-type color.
%     if (ischar(roi.color))
%         for(ii=1:3)
%             colorOverlay(ii,nodeInds) = stdColVals(ii, findstr(stdColLabs, roi.color));
%         end
%     else
%         % Check to see if we have a 3x1 vector.
%         roi.color=roi.color(:);
%         if (length(roi.color)==3)
%             colorOverlay(:,nodeInds)=repmat(roi.color(:)*255,1,length(nodeInds));
%         else
%             error('Bad ROI color');
%         end
%
%     end
%     dataMaskIndices = [dataMaskIndices, nodeInds'];
% end
