function ipROI = vol2ipROI(volROI,volView,ipView)
% 
% ipROI = vol2ipROI(volROI,volView,ipView)
%
% Creates a inplane ROI from an volume ROI by mapping
% coordinates, keeping track of partial voluming
%    
% ipROI and volROI are ROI structures, like those found in 
% view.ROIs 
%
% volView must be the VOLUME structure.
% ipView must be the INPLANE structure.
%
% djh, 8/98.

global mrSESSION
global vANATOMYPATH

% Get voxel sizes to make sure that the transformation preserves volume
ipVoxSize = mrSESSION.inplanes.voxelSize;
volVoxSize = readVolAnatHeader(vANATOMYPATH);

% Transform ROI coordinates
xform = inv(mrSESSION.alignment);

coords = xformROIcoords(volROI.coords,xform,volVoxSize,ipVoxSize);

% Toss coords outside the inplanes
ipSize = viewSize(ipView);
indices = ((coords(1,:) >= 1) & (coords(1,:) <= ipSize(1)) & ...
    (coords(2,:) >= 1) & (coords(2,:) <= ipSize(2)) & ...
    (coords(3,:) >= 1) & (coords(3,:) <= ipSize(3)));
coords = coords(:,indices);

% Set the fields 
ipROI.coords = coords;
ipROI.color = volROI.color;
ipROI.name = volROI.name;
ipROI.viewType = ipView.viewType;

ipROI = sortFields(ipROI); % just to be safe

return;

%%%%%%%%%%%%%%
% Debug/test %
%%%%%%%%%%%%%%

volROI = VOLUME{1}.ROIs(VOLUME{1}.selectedROI);
ipROI = vol2ipROI(volROI,VOLUME{1},INPLANE{1});
newvolROI = ip2volROI(ipROI,INPLANE{1},VOLUME{1});
volROI.coords
newvolROI.coords
