function inplane = vol2ipCurROI(volume,inplane)
%
% inplane = vol2ipCurROI(volume,inplane)
%
% Calls vol2ipROI with the currently selected ROI.  Called from
% callback in xformInplaneMenu.
%
% djh, 8/98
% djh, 2/2001, replaced globals with local variables

if ~volume.selectedROI
  myErrorDlg('Must have a selected ROI in the Volume window before it can be transformed to the Inplane window.');
end

volROI = volume.ROIs(volume.selectedROI);
ipROI = vol2ipROI(volROI,volume,inplane);
inplane = addROI(inplane,ipROI,1);
