function view = buildGrayCoords(view,pathStr,keepAll);
% view = buildGrayCoords(view,pathStr):
%
% Build a coords.mat file for a gray view. This was split
% off from getGrayCoords when I found the design was getting
% unwieldy -- even when a coords file had been built, there were
% still frequent checks on external files, and I was asked to 
% rebuild this nearly every time. I consolidated all of the looking
% for external files into this function -- anything required for 
% a gray view that's not already contained in a session directory
% should be loaded up here, and saved to coords.mat. This should
% happen a maximum of once per session/segmentation.
%
% ras 08/04.
global mrSESSION

if (ieNotDefined('keepAll'))
    keepAll=0;
end

% load the gray coords from the class/gray files
if (~isfield(view,'leftPath')), view = viewSet(view,'leftpath','(none assigned)');     end
if (~isfield(view,'rightPath')), view = viewSet(view,'rightPath','(none assigned)');   end

% Load the gray nodes and edges
if check4File(view.leftPath)
    [allLeftNodes allLeftEdges leftPath] = ...
        loadGrayNodes('left', view.leftPath);
else
    [allLeftNodes allLeftEdges leftPath] = loadGrayNodes('left');
end

if check4File(view.rightPath)
    [allRightNodes allRightEdges rightPath] = ...
        loadGrayNodes('right', view.rightPath);
else
    [allRightNodes allRightEdges rightPath] = loadGrayNodes('right');
end

% get left/right class files, too, if they're there:
% it wasn't clear to me where this got specified in the
% earlier code:
startDir = fullfile(getAnatomyPath(mrSESSION.subject), 'Left');
ttltxt = 'Select left hemisphere class file (cancel if none)...';
leftClassFile = getPathStrDialog(startDir, ttltxt, '*.?lass')

startDir = fullfile(getAnatomyPath(mrSESSION.subject), 'Right');
ttltxt = 'Select right hemisphere class file (cancel if none)...';
rightClassFile = getPathStrDialog(startDir, ttltxt, '*.?lass')

% Load the inplane coords (loaded temporarily into view.coords)
view = getVolCoords(view);
ipCoords = view.coords;


if (keepAll) % Here, we have the option to include all the nodes in the gray view. However, we can't map back to the inplane any more.     
    disp('Warning: You are keeping all the gray nodes (not computing an intersection with the inplane). This can be useful in some circumstances. But it also means that you can never map things back to the INPLANE view');
    
    leftNodes = allLeftNodes;
    leftEdges = allLeftEdges;
    leftCoords = uint8(allLeftNodes([2 1 3],:));
    keepLeft = [1:length(leftNodes)];
    
    rightNodes = allRightNodes;
    rightEdges = allRightEdges;
    rightCoords = uint8(allRightNodes([2 1 3],:));
    keepRight = [1:length(rightNodes)];
else

    waitHandle = waitbar(0,'Computing gray coordinates.  Please wait...');
    if ~isempty(allLeftNodes)
        % Find gray nodes that are in the inplanes. Note: nodes are
        % (x,y,z) not (y,x,z), unlike everything else in mrLoadRet.
        [leftCoords,ipIndices,keepLeft] = intersectCols(uint8(ipCoords),uint8(allLeftNodes([2 1 3],:)));

        % Keep nodes that intersect with the inplanes
        [leftNodes,leftEdges,nLeftNotReached] = keepNodes(allLeftNodes,allLeftEdges,double(keepLeft));
    else
        leftNodes=[];
        leftEdges=[];
        leftCoords=[];
        keepLeft = [];
    end

    % Repeat for right hemisphere
    waitbar(1/2)
    if ~isempty(allRightNodes)
        [rightCoords ipIndices keepRight] = ...
            intersectCols(uint8(ipCoords), uint8(allRightNodes([2 1 3],:)));
        [rightNodes rightEdges nRightNotReached] = ...
            keepNodes(allRightNodes, allRightEdges, keepRight);
    else
        rightNodes=[];
        rightEdges=[];
        rightCoords=[];
        keepRight = [];
    end
    close(waitHandle);
end % End check on whether we intersect with inplane


% Concatenate coords from the two hemispheres
coords = [double(leftCoords) double(rightCoords)];

% Concantenate the left and right gray graphs
if ~isempty(rightNodes)
    rightNodes(5,:) = rightNodes(5,:) + length(leftEdges);
    rightEdges = rightEdges + size(leftNodes,2);
end

nodes = [leftNodes rightNodes];
edges = [leftEdges rightEdges];

% make path local, if HOMEDIR is contained within it
% (this happens if, for instance, the vAnat directory is 
% linked to from the session directory):
global HOMEDIR
if findstr(leftPath,HOMEDIR);
    leftPath = leftPath(length(HOMEDIR)+2:end) % +2 b/c of filesep
    leftPath(leftPath=='\') = '/';  % \ win filesep -> / generic filesep
end
if findstr(rightPath,HOMEDIR);
    rightPath = rightPath(length(HOMEDIR)+2:end)
    rightPath(rightPath=='\') = '/';  % \ win filesep -> / generic filesep
end

% make path local, if HOMEDIR is contained within it
if findstr(leftClassFile,HOMEDIR);
    leftClassFile = leftClassFile(length(HOMEDIR)+2:end) % +2 b/c of filesep
    leftClassFile(leftClassFile=='\') = '/';  % \ win filesep -> / generic filesep
end
if findstr(rightClassFile,HOMEDIR);
    rightClassFile = rightClassFile(length(HOMEDIR)+2:end)
    rightClassFile(rightClassFile=='\') = '/';  % \ win filesep -> / generic filesep
end

% Save to coords file
save(pathStr,'coords','nodes','edges',...
    'allLeftNodes','allLeftEdges','allRightNodes','allRightEdges',...
    'leftPath','rightPath','keepLeft','keepRight');

if exist('leftClassFile','var')
    save(pathStr,'leftClassFile','-append');
end

if exist('rightClassFile','var')
    save(pathStr,'rightClassFile','-append');
end

fprintf('Saved gray coords info to %s. \n',pathStr);

return
