function view = zoomInplane(view, resetFlag);
% view = zoomInplane(view, <resetFlag=0>);
%
% Zooms the 3-view. Allows the subject to click once (rect or center of
% zooming) on one of the views of the brain, gets the new extent of view, 
% and sets the other axes to be consistent with the new zoom extent.
%
% resetFlag: if 1, will reset the zoom to be the whole view size and 
% update the axis bounds of the image. If 0 <default>, will get the zoom
% from the user input.
%
% 05/04 ras, from zoom3view.
% 06/02 ras: now just updates zoom w/ AXIS command, rather than
% going through a full refresh. Also added resetFlag, so both 
% zoom buttons have callbacks to this function (for Inplane/Flat views).
montageFlag = 1;

% this should only work on Inplane or Flat views
if ~ismember(view.viewType,{'Inplane' 'Flat'}),    return;      end

if exist('resetFlag', 'var') & resetFlag==1
    % reset the zoom
    dims = viewSize(view);
    zoom = [1 dims(2) 1 dims(1)];
else
    %%%%%%%%%%%%%%%%%%%%
    % Get data from UI %
    %%%%%%%%%%%%%%%%%%%%
    [X Y] = ginput(2);

    % Make sure 2nd value is larger than the 1st.
    if (X(2) < X(1)), X = flipud(X);  end
    if (Y(2) < Y(1)), Y = flipud(Y);  end

    zoom = [X(1) X(2) Y(1) Y(2)];

    % montage views will need some fiddling:
    if isfield(view.ui,'montageSize') | isfield(view.ui,'numLevelEdit')
        montageFlag = 1;
        [zoom rows cols] = montage2Coords(view,[X Y]');        

        % set to zoom format [xmin xmax ymin ymax]
        zoom = [zoom(1,1) zoom(1,2) zoom(2,1) zoom(2,2)];

        % get current zoom size 
        dims = viewSize(view);

        % allow for the points to be in different slices;
        % in this case take the zoomed part from the 
        % slice that the first click was in
        if cols(1) > cols(2)  % clip xmin
            zoom(1) = 1;
        elseif cols(2) > cols(1) % clip xmax
            zoom(2) = dims(2);
        end

        if rows(1) > rows(2) % clip ymin
            zoom(3) = 1;
        elseif rows(2) > rows(1) % clip ymax
            zoom(4) = dims(1);
        end
    else
        montageFlag = 0;
    end
end

view.ui.zoom = zoom;

axes(view.ui.mainAxisHandle);
if montageFlag==1
    % we need to refresh the screen
    view = refreshScreen(view);    
else
    % we can just use the zoom directly
    axis(zoom);
end


return



% zoom on
% 
% waitForClick = ginput(1); 
% 
% zoom = round(axis);
