function view = viewSet(view,param,val,varargin)
%
%   view = viewSet(view,param,val,varargin)
%
% Author: Wandell
% Purpose:
%  Organize methods for setting view (FLAT,INPLANE,VOLUME) parameters. 
%
if ieNotDefined('view'), error('No view defined.'); end
if ieNotDefined('param'), error('No parameter defined'); end
if ieNotDefined('val'), val = []; end

switch(view.viewType)
    case {'Gray','Volume'}
        view = volSet(view,param,val,varargin);
    case 'Flat'
        view = flatSet(view,param,val,varargin);
    case 'Inplane'
        view = ipSet(view,param,val,varargin);
end

% Should we also run a refreshView here, unless the window is hidden?
% view = refreshView(view);

return;


%------------------------------
function VOLUME  = volSet(VOLUME,param,val,varargin)

args = varargin{1};

switch lower(param)
    case {'homedir','homedirectory','sessiondirectory'}
        global HOMEDIR
        HOMEDIR = val;
        
    case {'name'}
        VOLUME.name = val;
    case {'viewtype','type'}
        VOLUME.viewType = val;
    case {'subdir'}
        VOLUME.subdir = val;
        
    case {'anatomy','anat'}
        VOLUME.anat = val;
    case {'coherence','co'}
        % This must be a cell array of 1 x nScans
        VOLUME.co = val;
    case {'scanco','scancoherence','coherencen'}
        if length(args) < 1, error('You must specify a scan number.'); end
        scan = args{1};
        VOLUME.co{scan} = val;
    case {'phase','ph'}
        VOLUME.ph = val;
    case {'scanph','scanphase','phasen'}
        if length(args) < 1, error('You must specify a scan number.'); end
        scan = args{1};
        VOLUME.ph{scan} = val;
    case {'amplitude','amp'}
        VOLUME.amp = val;
    case {'scanamp','scanamplitude','ampn'}
        if length(args) < 1, error('You must specify a scan number.'); end
        scan = args{1};
        VOLUME.ph{scan} = val;
    case {'statisticalmap','map','smap'}
        VOLUME.map = val;
    case {'mapname'}
        VOLUME.mapName = val;
    case {'scanmap','scanstatisticalamplitude','mapn','smapn'}
        if length(args) < 1, error('You must specify a scan number.'); end
        scan = args{1};
        VOLUME.map{scan} = val;
        
        % UI information
    case {'ui'}
        VOLUME.ui = val;
    case {'anatomymode','anatmode'}
        VOLUME.ui.anatMode = val;
    case {'correlationmode','coherencemode','comode'}
       VOLUME.ui.coMode = val;
    case {'phasemode','phmode'}
         VOLUME.ui.phMode = val;
    case {'amplitudemode','ampmode'}
        VOLUME.ui.ampMode = val;
    case {'mapmode','parametermapmode'}
        VOLUME.ui.mapMode = val;
    case {'displaymode','dispmode'}
        VOLUME.ui.displayMode = val;
        
    case {'brightness','bright'}
        setSlider(VOLUME,VOLUME.ui.brightness,val);
    case {'contrast'}
        setSlider(VOLUME,VOLUME.ui.contrast,val);        
        
    case {'cmapphase','phasemap','phasecolormap','phcolormap'}
        nGrays = viewGet(VOLUME, 'curnumgrays');
        VOLUME.ui.phMode.cmap((nGrays+1):end,:) = val' / 255;
    case {'curmodecmap','curcmap', 'currentcmap'}
        nGrays = viewGet(VOLUME, 'curnumgrays');
        eval(['VOLUME.ui.' VOLUME.ui.displayMode 'Mode.cmap(nGrays+1:end,:) = val'' / 255;']);
        
        
    % ras 05/05: new way of setting ROI options
    case {'roioptions','roiprefs','roiopts'}
        if ~isempty(val) & isstruct(val)
            VOLUME = roiSetOptions(VOLUME,val);
        else
            VOLUME = roiSetOptions(VOLUME);
        end
    case {'filledperimeter','filledperimeterstate'}
         VOLUME.ui.filledPerimeter = val;
    
       % Edge information     
    case {'nodes'}
        VOLUME.nodes = val;
    case {'edges'}
        VOLUME.edges = val;
    case {'allleftnodes'}
        VOLUME.allLeftNodes = val;
    case {'allleftedges'}
        VOLUME.allLeftEdges = val;
    case {'allrightnodes'}
        VOLUME.allRightNodes = val;
    case {'allrightedges'}
        VOLUME.allRightEdges = val;
    case {'coords'}
        VOLUME.coords = val;
    case {'mmpervox'}
        VOLUME.mmPerVox = val;
        
        % MRM related commands
    case {'leftclassfile','leftclassfilename'}
        VOLUME.leftClassFile = val;
    case {'rightclassfile','rightclassfilename'}
        VOLUME.rightClassFile = val;
    case {'leftgrayfile','leftgrayfilename','leftpath'}
        VOLUME.leftPath = val;
    case {'rightgrayfile','rightgrayfilename','rightpath'}
       VOLUME.rightPath = val;
        
    case {'currentdatatype','curdatatype','curdt','datatypenumber'}
        VOLUME.curDataType = val;
        setDataTypePopup(VOLUME);
        
    case {'rois','allrois'}
        VOLUME.ROIs = val;
    case {'selectedroi','currentroi'}
        % VOLUME.selectedROI = val;
        selectROI(VOLUME,val);
    case {'curscan','currentscan','currentscannumber'}
        VOLUME = setCurScan(VOLUME,val);
    case {'curslice','currentslice','currentslicenumber'}
        VOLUME = setCurSlice(VOLUME,val);
          
    case {'tseries'}
        VOLUME.tSeries = val;
    case {'tseriesslice','slicetseries'}
        VOLUME.tSeriesSlice = val;
    case {'tseriesscan','tseriescan','scantseries'}
        VOLUME.tSeriesScan = val;
        
        % Mesh related commands
    case {'mesh','replacemesh'}
        % viewSet(VOLUME,'mesh',val,whichMesh)
        if length(args) > 0, whichMesh = args{1};
        else whichMesh = viewGet(VOLUME,'currentmeshn'); end
        
        if isempty(val), VOLUME = viewSet(VOLUME, 'deleteMesh', whichMesh);
        else VOLUME.mesh{whichMesh} = val;
        end
        
    case {'currentmesh'}
        whichMesh = viewGet(VOLUME,'currentmeshn');
        VOLUME.mesh{whichMesh} = val;
    case {'allmeshes'}
        VOLUME.mesh = val;
    case {'addmesh','addandselectmesh'}
        % viewSet(VOLUME{1},'addmesh',msh,3);
        if ~isempty(args), newMeshNum = args{1};  % User specified the mesh number
        elseif(isfield(VOLUME,'mesh')), newMeshNum = length(VOLUME.mesh)+1; % add to meshes
        else newMeshNum = 1;                       % or make it the first mesh.
        end
        if ~meshCheck(val),warning('Non-standard mesh being added'); end
        % ras 01/06: not all fields always agree -- I think the
        % 'path' field hasn't been set yet, but haven't had a chance
        % to test that. So, for now, just deal the fields and lose
        % some info (potentially).
        % Not sure why this was here.  BW/BW removed. 02/06
        %         for f = fieldnames(val)'
        %             VOLUME.mesh{newMeshNum}.(f{1}) = val.(f{1});
        %         end
        VOLUME.mesh{newMeshNum} = val;
        VOLUME = viewSet(VOLUME, 'currentmeshn', newMeshNum);
    case {'meshdata'}
        curMesh = viewGet(VOLUME,'meshn');
        VOLUME.mesh{curMesh}.data = val;
    case {'meshn','currentmeshn','setcurrentmeshn'}
        VOLUME.meshNum3d = val;
    case {'deletemesh'}
        % viewSet(v,'deleteMesh',val);
        VOLUME.mesh = removeListElement(VOLUME.mesh,val);
        VOLUME = viewSet(VOLUME,'currentmeshn',max(1,min(val)-1));
        % If there are no meshes left in the array, we clear the  mesh
        % array and select mesh 0.
        if(isempty(VOLUME.mesh))
            VOLUME = rmfield(VOLUME, 'mesh');
            VOLUME = viewSet(VOLUME,'currentmeshn',0);
        end
        
    case {'rmfile','retinotopyModelFile'}
        VOLUME.rm.retinotopyModelFile = val;
     
    otherwise
        error('Unknown VOLUME parameter.');
end

return;


%------------------------------
function FLAT  = flatSet(FLAT,param,val,varargin)

args = varargin{1};

switch lower(param)
    case {'homedir','homedirectory','sessiondirectory'}
        global HOMEDIR
        HOMEDIR = val;
        
    case {'name'}
        FLAT.name = val;
    case {'viewtype','type'}
        FLAT.viewType = val;
    case {'subdir'}
        FLAT.subdir = val;
        
    case {'currentdatatype','curdatatype','curdt','datatypenumber'}
        FLAT.curDataType = val;
        setDataTypePopup(FLAT);
        
    % UI information
    case {'ui'}
        VOLUME.ui = val;
        
    case {'tseries'}
        FLAT.tSeries = val;
    case {'tseriesslice','slicetseries'}
        FLAT.tSeriesSlice = val;
    case {'tseriesscan','tseriescan','scantseries'}
        FLAT.tSeriesScan = val;
        
    case {'selectedroi','currentroi'}
        % FLAT.selectedROI = val;
        selectROI(FLAT,val);
    case {'curscan','currentscan','currentscannumber'}
        FLAT = setCurScan(FLAT,val);
    case {'curslice','currentslice','currentslicenumber'}
        FLAT = setCurSlice(FLAT,val);
        
    case {'co','coherence'}
        FLAT.co = val;
    case {'amp','ampitude'}
        FLAT.amp = val;
    case {'ph','phase'}
        FLAT.ph = val;
    case {'map','statisticalmap'}
        FLAT.map = val;
    case {'mapname'}
        FLAT.mapName = val;
        
        % UI information
    case {'anatomymode','anatmode'}
        FLAT.ui.anatMode = val;
    case {'correlationmode','coherencemode','comode'}
        FLAT.ui.coMode = val;
    case {'phasemode','phmode'}
        FLAT.ui.phMode = val;
    case {'amplitudemode','ampmode'}
        FLAT.ui.ampMode = val;
    case {'displaymode','dispmode'}
        FLAT.ui.displayMode = val;
    case {'mapmode'}
        FLAT.ui.mapMode = val;
    case {'filledperimeter','filledperimeterstate'}
        FLAT.ui.filledPerimeter = val;
    case {'roioptions','roiprefs','roiopts'}
        if ~isempty(val) & isstruct(val)
            FLAT = roiSetOptions(FLAT,val);
        else
            FLAT = roiSetOptions(FLAT);
        end
         
    case {'cmapphase','phasemap','phasecolormap','phcolormap'}
        nGrays = viewGet(FLAT, 'curnumgrays');
        FLAT.ui.phMode.cmap((nGrays+1):end,:) = val' / 255;
    case {'curmodecmap','curcmap', 'currentcmap'}
        nGrays = viewGet(FLAT, 'curnumgrays');
        eval(['FLAT.ui.' FLAT.ui.displayMode 'Mode.cmap(nGrays+1:end,:) = val'' / 255;']);
            
    case {'brightness','bright'}
        setBrightness(FLAT,val);
    case {'contrast'}
        setSlider(FLAT,FLAT.ui.contrast,val);
        
    case {'rmfile','retinotopyModelFile'}
        FLAT.rm.retinotopyModelFile = val;
        
    otherwise
        error('Unknown FLAT parameter.');
        
end


return;



%------------------------------
function INPLANE  = ipSet(INPLANE,param,val,varargin)

args = varargin{1};

switch lower(param)
    case {'homedir','homedirectory','sessiondirectory'}
        global HOMEDIR
        HOMEDIR = val;
        
    case {'name'}
        INPLANE.name = val;
    case {'viewtype','type'}
        INPLANE.viewType = val;
    case {'subdir'}
        INPLANE.subdir = val;
        
    case {'currentdatatype','curdatatype','curdt','datatypenumber'}
        INPLANE.curDataType = val;
        setDataTypePopup(INPLANE);
        
    case {'selectedroi','currentroi'}
        % INPLANE.selectedROI = val;
        selectROI(INPLANE,val);
    case {'curscan','currentscan','currentscannumber'}
        INPLANE = setCurScan(INPLANE,val);
    case {'curslice','currentslice','currentslicenumber'}
        INPLANE = setCurSlice(INPLANE,val);
        
    case {'tseries'}
        INPLANE.tSeries = val;
    case {'tseriesslice','slicetseries'}
        INPLANE.tSeriesSlice = val;
    case {'tseriesscan','tseriescan','scantseries'}
        INPLANE.tSeriesScan = val;
        
    case {'co','coherence'}
        INPLANE.co = val;
    case {'amp','ampitude'}
        INPLANE.amp = val;
    case {'ph','phase'}
        INPLANE.ph = val;
    case {'map','statisticalmap'}
        INPLANE.map = val;
    case {'mapname'}
        INPLANE.mapName = val;
                
    case {'ui','userinterface'}
        INPLANE.ui = val;
        
    case {'rois'}
        INPLANE.ROIs = val;
    % UI information
    case {'anatomymode','anatmode'}
        INPLANE.ui.anatMode = val;
    case {'correlationmode','coherencemode','comode'}
        INPLANE.ui.coMode = val;
    case {'phasemode','phmode'}
        INPLANE.ui.phMode = val;
    case {'amplitudemode','ampmode'}
        INPLANE.ui.ampMode = val;
    case {'mapmode'}
        INPLANE.ui.mapMode = val;
    case {'displaymode','dispmode'}
        INPLANE.ui.displayMode = val;        
    case {'cmapphase','phasemap','phasecolormap','phcolormap'}
        nGrays = viewGet(INPLANE, 'curnumgrays');
        INPLANE.ui.phMode.cmap((nGrays+1):end,:) = val' / 255;
    case {'curmodecmap','curcmap', 'currentcmap'}
        nGrays = viewGet(INPLANE, 'curnumgrays');
        eval(['INPLANE.ui.' INPLANE.ui.displayMode 'Mode.cmap(nGrays+1:end,:) = val'' / 255;']);
        

    case {'brightness','bright'}
        setSlider(INPLANE,INPLANE.ui.brightness,val);
    case {'contrast'}
        setSlider(INPLANE,INPLANE.ui.contrast,val);        
        
    % ras 05/05: new way of setting ROI options
    case {'roioptions','roiprefs','roiopts'}
        if ~isempty(val) & isstruct(val)
            INPLANE = roiSetOptions(INPLANE,val);
        else
            INPLANE = roiSetOptions(INPLANE);
        end
    case {'filledperimeter','filledperimeterstate'}
        INPLANE.ui.filledPerimeter = val;
        
    case {'rmfile','retinotopyModelFile'}
        INPLANE.rm.retinotopyModelFile = val;
 
 
    otherwise
        error('Unknown INPLANE parameter.');
        
end


return
