function val = viewGet(view,param,varargin)
% Retrieve data from various view structures
%
%  val = viewGet(view,param,varargin)
%
% Read the parameters of a view (VOLUME/GRAY, FLAT, INPLANE).
% Access to these structures should go through this routine and through%    viewSet.
% At present, this is far from true.  Work towards that goal.
% 
%
%

% TODO:
%  We need to have a call data = viewGet(INPLANE,'data','co',roiName);
%  This would call getCurDataROI or just insert that function in place
%  here.
%

if ieNotDefined('view'), error('No view defined.'); end
if ieNotDefined('param'), error('No parameter defined'); end


switch(view.viewType)
    case {'Gray','Volume','generalGray'}
        val = volGet(view,param,varargin);
    case 'Flat'
        val = flatGet(view,param,varargin);
    case 'Inplane'
        val = ipGet(view,param,varargin);
    otherwise
        error('Unknown type of View.');
end
return;
% /-------------------------------------------------------------/ %




% /-------------------------------------------------------------/ %
% N.B.  For all the routines below, varargin{1} is the varargin passed in by the% main routine. Hence, the first entry varargin{1}, is the entire varargin% in the calling routine. %------------------------------
function val  = volGet(VOLUME,param,varargin)
val = [];
arg = varargin{1};

switch lower(param)
    case {'homedir','homedirectory','sessiondirectory'}
        global HOMEDIR
        val = HOMEDIR;
    case {'name'}
        val = VOLUME.name;
    case {'viewtype','type'}
        val = VOLUME.viewType;
    case {'subdir'}
        val = VOLUME.subdir;

    case {'co','coherence','allcoherence'}
        val = VOLUME.co;
    case {'scanco','coherencen','scancoherence'}
        % co = viewGet(view,'scanco',1);
        if length(arg) < 1 error('Scan number required.');
        else nScan = arg{1};
        end
        if ~isempty(VOLUME.co)
            val = VOLUME.co{nScan};
        else
            val = [];
        end
        %     case {'coherencemap','coherencecolormap','cocolormap'}%
        %         val = round(VOLUME.ui.coMode.cmap(65:end,:) * 255)';%
        %
    case {'ph','phase','allphase'}
        val = VOLUME.ph;
    case {'scanphase','phasen','scanph'}
        % co = viewGet(view,'scanphase',1);
        if length(arg) < 1 error('Scan number required.');
        else nScan = arg{1};
        end
        if ~isempty(VOLUME.ph)
            val = VOLUME.ph{nScan};
        else
            val = [];
        end
        %     case {'phasemap','phasecolormap','phcolormap'}
        %         val = round(VOLUME.ui.phMode.cmap(65:end,:) * 255)';
    case {'amp','amplitude','allamp'}
        val = VOLUME.amp;
    case {'scanamp','amplituden'}
        if length(arg) < 1 error('Scan number required.');
        else nScan = arg{1};
        end
        if ~isempty(VOLUME.amp)
            val = VOLUME.amp{nScan};
        else
            val = [];
        end
    case {'ampmap','ampcolormap'}
        val = round(VOLUME.ui.ampMode.cmap(65:end,:) * 255)';

    case {'map','statisticalmap','allmap'}
        val = VOLUME.map;
    case {'mapwin','mapwindow','parammapwin'}
        val = getMapWindow(VOLUME);
    case {'mapname'}
        val = VOLUME.mapName;
    case {'mapn','scanstatisticalmap','scanmap'}
        if length(arg) < 1 error('Scan number required.');
        else nScan = arg{1};
        end

        % Sometimes there is no map loaded. If this is the case,
        % return an empty array rather than crashing
        nMaps=length(VOLUME.map);
        if (nMaps>=nScan)
            val = VOLUME.map{nScan};
        else
            val=[];
        end

    case {'anatomy','anat'}
        val = VOLUME.anat;
    case {'anatomymap','anatomycolormap','anatmap'}
        val = round(VOLUME.ui.phMode.cmap(1:64,:) * 255)';
    case {'anatclip','anatwin'}
        val = getAnatClip(VOLUME);
    case {'anatomysize','anatsize','sizeanatomy'}
        val = size(VOLUME.anat);
    case {'anatsizexyz','anatomysizeforclass'}
        % The class data store the planes in a different order from the
        % view.anat.  If you want sizes that work for the class data, call
        % this size.
        val = viewGet(VOLUME,'anatomysize');
        val = val([2,1,3]);
    case {'brightness','bright'}
        val = get(VOLUME.ui.brightness.sliderHandle,'Value');
    case {'contrast'}
        val = get(VOLUME.ui.contrast.sliderHandle,'Value');
    case {'mmpervox','mmpervoxel','millimeterpervoxel'}
        val = VOLUME.mmPerVox;

    case {'userinterface','ui'}
        val = VOLUME.ui;
    case {'fignum','figurenumber'}
        val = VOLUME.ui.figNum;
    case {'windowhandle'}
        val = VOLUME.ui.windowHandle;
    case {'displaymode'}
        val = VOLUME.ui.displayMode;

    case {'coherencethreshold','cothresh'}
        val = get(VOLUME.ui.cothresh.sliderHandle,'Value');
    case {'coherencemap','coherencecolormap'}
        nGrays = viewGet(VOLUME, 'curnumgrays');        val = round(VOLUME.ui.coMode.cmap((nGrays+1):end,:) * 255)';
    case {'phasewindow','phwindow','phasewin','phaserange'}
        val = ...
            [get(VOLUME.ui.phWinMin.sliderHandle,'Value'),...
            get(VOLUME.ui.phWinMax.sliderHandle,'Value')];
    case {'mapwindow','statisticalmapwindow','smapwindow','statmapwindow'}
        val = ...
            [get(VOLUME.ui.mapWinMin.sliderHandle,'Value'),...
            get(VOLUME.ui.mapWinMax.sliderHandle,'Value')];
 
    case {'tr','frameperiod'}
        global dataTYPES;
        dt = viewGet(VOLUME,'curdt');
        scan = viewGet(VOLUME,'curscan');
        val = dataTYPES(dt).scanParams(scan).framePeriod;
    case {'nframes','numframes','number of timeframes'}
        global dataTYPES;
        dt = viewGet(VOLUME,'curdt');
        scan = viewGet(VOLUME,'curscan');
        val = dataTYPES(dt).scanParams(scan).nFrames;

    case {'anatomymode','anatmode'}
        val = VOLUME.ui.anatMode;
    case {'correlationmode','coherencemode','comode'}
        val = VOLUME.ui.coMode;
    case {'phasemode','phmode'}
        val = VOLUME.ui.phMode;
    case {'amplitudemode','ampmode'}
        val = VOLUME.ui.ampMode;
    case {'mapmode'}
        val = VOLUME.ui.mapMode;
    case {'cmapphase','phasemap','phasecolormap','phcolormap'}
        % This returns only the color part of the map
        nGrays = viewGet(VOLUME, 'curnumgrays');
        val = round(VOLUME.ui.phMode.cmap(nGrays+1:end,:) * 255)';
    case {'cmapcurrent','curmodecmap','curcmap', 'currentcmap'}
        nGrays = viewGet(VOLUME, 'curnumgrays');
        eval(['val = round(VOLUME.ui.' VOLUME.ui.displayMode 'Mode.cmap(nGrays+1:end,:) * 255)'';']);

    case {'cmapcurmodeclip','curmodecmapclip'}
        eval(['val = VOLUME.ui.' VOLUME.ui.displayMode 'Mode.clipMode;']);
    case {'cmapcurnumgrays','curnumgrays','currentnumberofgrays'}
        eval(['val = VOLUME.ui.' VOLUME.ui.displayMode 'Mode.numGrays;']);
    case {'cmapcurnumcolors','curnumcolors','currentnumberofcolors'}
        eval(['val = VOLUME.ui.' VOLUME.ui.displayMode 'Mode.numColors;']);

    case {'filledperimeter','filledperimeterstate'}
        if ~checkfields(VOLUME,'ui','filledPerimeter') return;
        else  val = VOLUME.ui.filledPerimeter; end
    case {'selroicolor','roicolor','selectedroicolor'}
        if checkfields(VOLUME,'ui','selRoiColor')
            val = VOLUME.ui.selRoiColor;
        else
            val = [1 1 1]; % white   default
        end

    case {'classfilename','classfile','classpath'}
        if (length(arg) == 1), hemisphere = arg{1};
        else error('You must specify right/left hemisphere.');
        end
        switch hemisphere
            case 'left'
                if ~checkfields(VOLUME,'leftClassFile') | isempty(VOLUME.leftClassFile);
                    [noData,val] = GetClassFile(VOLUME, 0, 1);
                else
                    val = VOLUME.leftClassFile;
                end
            case 'right'
                if ~checkfields(VOLUME,'rightClassFile') | isempty(VOLUME.rightClassFile)
                    [noData,val] = GetClassFile(VOLUME, 1, 1);
                else
                    val = VOLUME.rightClassFile;
                end
            otherwise
                error('Unknown hemisphere');
        end

    case {'classdata','class','classification','whitematter'}
        % classFileRight = viewGet(view,'classdata','right');
        if length(arg) == 1, hemisphere = arg{1};
        else error('You must specify right/left hemisphere.'); end
        switch hemisphere
            case 'left'
                [val,leftClassFile]   = GetClassFile(VOLUME, 0);
            case 'right'
                [val, rightClassFile] = GetClassFile(VOLUME, 1);
            otherwise
                error('Unknown hemisphere');
        end

    case {'graymatterfilename','graypath','grayfilename','grayfile'}
        % grayFile = viewGet(view,'graymatterfilename','right');
        if length(arg) == 1, hemisphere = arg{1};
        else error('You must specify right/left hemisphere.');
        end
        switch hemisphere
            case 'left'
                if checkfields(VOLUME,'leftPath')
                    val = VOLUME.leftPath;
                end
            case 'right'
                if checkfields(VOLUME,'rightPath')
                    val = VOLUME.rightPath;
                end
            otherwise
                error('Unknown hemisphere');
        end


    case {'allmeshes','meshlist','allmesh'}
        if checkfields(VOLUME,'mesh'), val = VOLUME.mesh; end
    case {'allmeshids','allwindowids','allmeshid','allwindowid'}
        % idList = viewGet(VOLUME{1},'allwindowids');
        nMesh = viewGet(VOLUME,'nmesh');
        if nMesh > 0
            for ii=1:nMesh, val(ii) = VOLUME.mesh{ii}.id; end
            val = val(val > -1);
        end

    case {'mesh'}
        if ~isempty(arg), whichMesh = arg{1};
        else whichMesh = viewGet(VOLUME,'currentmeshnumber'); end
        if ~isempty(whichMesh), val = VOLUME.mesh{whichMesh}; end
    case {'selectedmesh','currentmesh'}
        whichMesh = viewGet(VOLUME,'currentmeshnumber');
        if ~isempty(whichMesh) && (whichMesh > 0), val = VOLUME.mesh{whichMesh}; end
    case {'currentmeshnumber','selectedmeshn','selmeshn','curmeshn','currentmeshn'}
        if checkfields(VOLUME,'meshNum3d'), val = VOLUME.meshNum3d; end
    case {'currentmeshdata','meshdata','selectedmeshdata'}
        if checkfields(VOLUME,'mesh','data')
            selectedMesh = viewGet(view,'currentmeshnumber');
            val = VOLUME.mesh{selectedMesh}.data;
        end
    case {'nmesh','numberofmeshes'}
        if checkfields(VOLUME,'mesh'), val = length(VOLUME.mesh); else val = 0; end
    case {'meshnames'}
        if checkfields(VOLUME,'mesh')
            nMesh = viewGet(VOLUME,'nmesh');
            for ii=1:nMesh
                if checkfields(VOLUME.mesh{ii},'name')
                    val{ii} = VOLUME.mesh{ii}.name;
                else val{ii} = [];
                end
            end
        end
    case {'meshdir', 'meshdirectory'}
        anatDir = fileparts(getVAnatomyPath);
        val = fullfile(anatDir, 'Meshes');
        if ~exist(val, 'dir')
            val = anatDir;
        end

    case {'rois'}
        val = VOLUME.ROIs;
    case {'currentroi','curroi','selectedroi'}
        val = VOLUME.selectedROI;
    case {'curscan','currentscan','currentscannumber'}
        val = getCurScan(VOLUME);
    case {'curslice','currentslice','currentslicenumber'}
        val = getCurSlice(VOLUME);
    case {'nscans','numscans'}, 
        val = numScans(VOLUME);         
    case {'numslices','nslices'}
        val = numSlices(VOLUME);

    case {'tseries'}
        val = VOLUME.tSeries;
    case {'tseriesslice','slicetseries'}
        val = VOLUME.tSeriesSlice;
    case {'tseriesscan','tseriescan','scantseries'}
        val = VOLUME.tSeriesScan ;
    case {'currentdatatype','curdatatype','curdt','datatypenumber','datatype'}
        val = VOLUME.curDataType;

    case {'nodes'}
        val = VOLUME.nodes;
    case {'xyznodes'}   
        % Must call this sagittal, axial coronal or whatever the mapping is
        % 
        nodes = viewGet(VOLUME,'nodes');
        val = nodes(1:3,:);
    case {'nodegraylevel','nodesgraylevel'}
        nodes = viewGet(VOLUME,'nodes');
        val = nodes(6,:);
    case {'nnodes','numberofnodes'}
        val = size(VOLUME.nodes,2);
    case {'edges'}
        val = VOLUME.edges;
    case {'nedges','numberofedges'}
        val = length(VOLUME.edges);
    case {'allleftnodes'}
        val = VOLUME.allLeftNodes;
    case {'allleftedges'}
        val = VOLUME.allLeftEdges;
    case {'allrightnodes'}
        val = VOLUME.allRightNodes;
    case {'allrightedges'}
        val = VOLUME.allRightEdges;
    case {'coords','graycoords'}
        val = VOLUME.coords;
    case {'coordsfilename','coordsfile','graycoordsfile','graycoordsfilename'}
        homeDir = viewGet(VOLUME,'homedir');
        if isempty(homeDir), val = ['Gray',filesep','coords.mat'];
        else val = [homeDir,filesep,'Gray',filesep','coords.mat'];
        end
    case {'ncoords','numberofcoordinates','numbergraycoords'}
        val = size(VOLUME.coords,2);
    case {'mmpervox'}
        val = VOLUME.mmPerVox;
    case {'datasize','mapsize','functionalsize','funcsize'}
        val = dataSize(VOLUME);

    case {'rmfile','retinotopyModelFile'}
        val = VOLUME.rm.retinotopyModelFile;
        
        
    otherwise
        error('Unknown viewGet parameter');
end

return;
% /-------------------------------------------------------------/ %




%------------------------------
function val  = flatGet(FLAT,param,varargin)

val = [];
arg = varargin{1};

switch lower(param)
    case {'homedir','homedirectory','sessiondirectory'}
        global HOMEDIR
        val = HOMEDIR;

    case {'name'}
        val = FLAT.name;
    case {'viewtype','type'}
        val = FLAT.viewType;
    case {'curdatatype','curdt'}
        val = FLAT.curDataType;
    case {'subdir'}
        val = FLAT.subdir;

    case {'co','coherence'}
        val = FLAT.co;
    case {'scanco','coherencen','scancoherence'}
        % co = viewGet(view,'scanphase',1);
        if length(arg) < 1 error('Scan number required.');
        else nScan = arg{1};
        end
        val = FLAT.co{nScan};
    case {'ph','phase'}
        val = FLAT.ph;
    case {'scanphase','phasen','scanph'}
        % co = viewGet(view,'scanphase',1);
        if length(arg) < 1 error('Scan number required.');
        else nScan = arg{1};
        end
        val = FLAT.ph{nScan};

    case {'amp','amplitude'}
        val = FLAT.amp;

    case {'map'}
        val = FLAT.map;
    case {'mapwin','mapwindow','parammapwin'}
        val = getMapWindow(FLAT);
    case {'mapname'}
        val = FLAT.mapName;

    case {'brightness','bright'}
        val = get(FLAT.ui.brightness.sliderHandle,'Value');
    case {'contrast'}
        val = get(FLAT.ui.contrast.sliderHandle,'Value');   

    case {'currentdatatype','curdatatype','curdt','datatypenumber'}
        val = FLAT.curDataType;

    case {'tseries','timeseries'}
        val = FLAT.tSeries;
    case {'tseriesscan','scantseries'}
        val = FLAT.tSeriesScan;
    case {'tseriesslice'}
        val = FLAT.tSeriesSlice;

        
    case {'coords'}
        % val = viewGet(FLAT{1},'coords','left');
        if length(arg) ~= 1 , error('You must specify which hemisphere.'); end
        hname = arg{1};
        switch hname
            case 'left'
                val = FLAT.coords{1};
            case 'right'
                val = FLAT.coords{2};
            otherwise
                error('Bad hemisphere name');
        end
    case {'graycoords'}
        % val = viewGet(FLAT{1},'graycoords','left');
        if length(arg) ~= 1 , error('You must specify which hemisphere.'); end
        hname = arg{1};
        switch hname
            case 'left'
                val = FLAT.grayCoords{1};
            case 'right'
                val = FLAT.grayCoords{2};
            otherwise
                error('Bad hemisphere name');
        end

    case {'spatialgrad'}
        % What is this?
        val = FLAT.spatialGrad;

    case {'roi','rois'}
        val = FLAT.ROIs;
    case {'currentroi','curroi','selectedroi'}
        val = FLAT.selectedROI;
    case {'prevcoords','previouscoordinates'}
        % What is this?
        val = FLAT.prevCoords;

    case {'leftpath','flatleftpath'}
        if checkfields(FLAT,'leftPath'), val = FLAT.leftPath; end
    case {'rightpath','flatrightpath'}
        if checkfields(FLAT,'rightPath'), val = FLAT.rightPath; end

    case {'ui'}
        val = FLAT.ui;
    case {'anat','anatomy'}
        val = FLAT.anat;
    case {'anatomymode','anatmode'}
        val = FLAT.ui.anatMode;
    case {'anatclip','anatwin'}
        val = getAnatClip(FLAT);
    case {'correlationmode','coherencemode','comode'}
        val = FLAT.ui.coMode;
    case {'phasemode','phmode'}
        val = FLAT.ui.phMode;
    case {'amplitudemode','ampmode'}
        val = FLAT.ui.ampMode;
    case {'mapmode'}
        val = FLAT.ui.mapMode;
    case {'displaymode'}
        val = FLAT.ui.displayMode;
    case {'fignum','figurenumber'}
        val = FLAT.ui.figNum;

    case {'cmapphase','phasemap','phasecolormap','phcolormap'}
        % What is the difference between this map and the phase color
        % map above?  I think this one only gets the colors, not the
        % gray scale.  Check!
        nGrays = viewGet(FLAT, 'curnumgrays');
        val = round(FLAT.ui.phMode.cmap(nGrays+1:end,:) * 255)';
    case {'cmapcurrent','curmodecmap','curcmap', 'currentcmap'}
        nGrays = viewGet(FLAT, 'curnumgrays');
        eval(['val = round(FLAT.ui.' FLAT.ui.displayMode 'Mode.cmap(nGrays+1:end,:) * 255)'';']);

    case {'cmapcurmodeclip','curmodecmapclip'}
        eval(['val = FLAT.ui.' FLAT.ui.displayMode 'Mode.clipMode;']);
    case {'cmapcurnumgrays','curnumgrays','currentnumberofgrays'}
        eval(['val = FLAT.ui.' FLAT.ui.displayMode 'Mode.numGrays;']);
    case {'cmapcurnumcolors','curnumcolors','currentnumberofcolors'}
        eval(['val = FLAT.ui.' FLAT.ui.displayMode 'Mode.numColors;']);


    case {'filledperimeter','filledperimeterstate'}
        if ~checkfields(FLAT,'ui','filledPerimeter') return;
        else  val = FLAT.ui.filledPerimeter; end

    case {'selroicolor','roicolor','selectedroicolor'}
        if checkfields(FLAT,'ui','selRoiColor')
            val = FLAT.ui.selRoiColor;
        else
            val = [1 1 1]; % white default
        end

    case {'curscan','currentscan','currentscannumber'}
        val = getCurScan(FLAT);
    case {'curslice','currentslice','currentslicenumber'}
        val = getCurSlice(FLAT);
    case {'nscans','numscans'}, 
        val = numScans(FLAT); 
    case {'numslices','nslices'}
        val = numSlices(FLAT);

    case {'mapwin','mapwindow','statisticalmapwindow','smapwindow','statmapwindow'}
        val = ...
            [get(FLAT.ui.mapWinMin.sliderHandle,'Value'),...
            get(FLAT.ui.mapWinMax.sliderHandle,'Value')];

    case {'datasize','mapsize','functionalsize','funcsize'}
        val = dataSize(FLAT);     

    case {'flip','fliplr'}
        if checkfields(FLAT,'flipLR'), val = FLAT.flipLR; end
    case {'rotateimagedegrees','imagerotation'}
        if checkfields(FLAT,'rotateImageDegrees'),val = FLAT.rotateImageDegrees; end

    case {'rmfile','retinotopyModelFile'}
        val = FLAT.rm.retinotopyModelFile;
        
    otherwise
        error('Unknown FLAT parameter.');
end
return;
% /-------------------------------------------------------------/ %



%------------------------------
function val  = ipGet(INPLANE,param,varargin)

val = [];
arg = varargin{1};

switch lower(param)

    case {'homedir','homedirectory','sessiondirectory'}
        global HOMEDIR
        val = HOMEDIR;

    case {'anatomy','anat','inplanes'}
        val = INPLANE.anat;
    case {'name'}
        val = INPLANE.name;
    case {'viewtype','type'}
        val = INPLANE.viewType;
    case {'subdir'}
        val = INPLANE.subdir;

    case {'dt','currentdatatype','curdatatype','curdt','datatypenumber'}
        val = INPLANE.curDataType;
    case {'co','coherence'}
        val = INPLANE.co;
    case {'scanco','coherencen','scancoherence'}
        % co = viewGet(view,'scanphase',1);
        if length(arg) < 1
            error('Scan number required.');
        else
            nScan = arg{1};
        end
        val = INPLANE.co{nScan};
    case {'ph','phase'}
        val = INPLANE.ph;
    case {'scanphase','phasen','scanph'}
        % co = viewGet(view,'scanphase',1);
        if length(arg) < 1 error('Scan number required.');
        else nScan = arg{1};
        end
        val = INPLANE.ph{nScan};
    case {'amp'}
        val = INPLANE.amp;
    case {'map'}
        val = INPLANE.map;
    case {'mapname'}
        val = INPLANE.mapName;

    case {'anatclip','anatwin'}
        val = getAnatClip(INPLANE);
    case {'mapclip','mapwin'}
        val = getMapWindow(INPLANE);
    case {'phclip','phwin'}
        val = getPhWindow(INPLANE);
    case {'cothresh','cowin','comin'}
        val = getCothresh(INPLANE);

    case {'tr','frameperiod'}
        global dataTYPES;
        dt = viewGet(INPLANE,'curdt');
        scan = viewGet(INPLANE,'curscan');
        val = dataTYPES(dt).scanParams(scan).framePeriod;
    case {'nframes','numframes','number of timeframes'}
        global dataTYPES;
        dt = viewGet(INPLANE,'curdt');
        scan = viewGet(INPLANE,'curscan');
        val = dataTYPES(dt).scanParams(scan).nFrames;

        % UI information
    case {'ui'}
        val = INPLANE.ui;
    case {'displaymode'}
        val = INPLANE.ui.displayMode;
    case {'anatomymode','anatmode'}
        val = INPLANE.ui.anatMode;
    case {'correlationmode','coherencemode','comode'}
        val = INPLANE.ui.coMode;
    case {'phasemode','phmode'}
        val = INPLANE.ui.phMode;
    case {'amplitudemode','ampmode'}
        val = INPLANE.ui.ampMode;
    case {'mapmode'}
        val = INPLANE.ui.mapMode;
    case {'fignum','figurenumber'}
        val = INPLANE.ui.figNum;

    case {'cmapphase','phasemap','phasecolormap','phcolormap'}
        % This returns only the color part of the map
        nGrays = viewGet(INPLANE, 'curnumgrays');
        val = round(INPLANE.ui.phMode.cmap(nGrays+1:end,:) * 255)';
    case {'cmapcurrent','curmodecmap','curcmap', 'currentcmap'}
        nGrays = viewGet(INPLANE, 'curnumgrays');
        eval(['val = round(INPLANE.ui.' INPLANE.ui.displayMode 'Mode.cmap(nGrays+1:end,:) * 255)'';']);

    case {'cmapcurmodeclip','curmodecmapclip'}
        eval(['val = INPLANE.ui.' INPLANE.ui.displayMode 'Mode.clipMode;']);
    case {'cmapcurnumgrays','curnumgrays','currentnumberofgrays'}
        eval(['val = INPLANE.ui.' INPLANE.ui.displayMode 'Mode.numGrays;']);
    case {'cmapcurnumcolors','curnumcolors','currentnumberofcolors'}
        eval(['val = INPLANE.ui.' INPLANE.ui.displayMode 'Mode.numColors;']);

    case {'brightness','bright'}
        val = get(INPLANE.ui.brightness.sliderHandle,'Value');
    case {'contrast'}
        val = get(INPLANE.ui.contrast.sliderHandle,'Value');

    case {'filledperimeter','filledperimeterstate'}
        if ~checkfields(INPLANE,'ui','filledPerimeter')
            return;
        else
            val = INPLANE.ui.filledPerimeter;
        end

    case {'selroicolor','roicolor','selectedroicolor'}
        if checkfields(INPLANE,'ui','selRoiColor')
            val = INPLANE.ui.selRoiColor;
        else
            val = [1 1 1]; % white default
        end

    case {'roi','rois'}
        val = INPLANE.ROIs;
    case {'currentroi','curroi','selectedroi'}
        val = INPLANE.selectedROI;
    case {'curscan','currentscan','currentscannumber'}
        val = getCurScan(INPLANE);
    case {'curslice','currentslice','currentslicenumber'}
        val = getCurSlice(INPLANE);
    case {'nscans','numscans'}, 
        val = numScans(INPLANE);         
    case {'numslices','nslices'}, 
        val = numSlices(INPLANE);
    case {'datasize','mapsize','functionalsize','funcsize'}
        val = dataSize(INPLANE);

    case {'rmfile','retinotopyModelFile'}
        val = INPLANE.rm.retinotopyModelFile;
 
    otherwise
        error('Unknown INPLANE parameter.')
end

return;
