function tseriesPict(view, scanNumList, frameNum, jpgPathStr)
% tseriesPict(view, [scanNumList], [frameNum], [jpgPathStr])
%
% displays a montage of all slices for each scan specified
% in scanNumList (defaults to all scans if omitted or empty).
%
% (The current directory should be where mrSESSION lives.)
%
% frameNum specifies the frame to extract.  (defaults to 1 if 
% omitted or empty)
%
% Also writes out the montages as jpeg files, if pathStr is
% specified. pathStr determines the directory/folder where the images
% will be saved. The filenames are: anat.jpg, scanN.jpg
%
% 99.03.12 RFD: wrote it.
% 99.04.05 RFD: added check for mrSESSION.cropTSeriesSize
% 3/2001, djh, updated to mrLoadRet-3.0
% - added view as first (required) argument
% - dumped pathstr that used to be last optional arg
if ~strcmp(view.viewType,'Inplane')
    myErrorDlg('tseriesPict: only for inplane views');
end
nScans = numScans(view);
if ~exist('scanNumList', 'var') | isempty(scanNumList)
    scanNumList = 1:nScans;
end

if ~exist('frameNum', 'var') | isempty(frameNum)
    frameNum = 1;
end
% Display inplanes
%
if isempty(view.anat)
    disp(['Extracting anatomies...']);
    view = loadAnat(view);
end
dims = size(view.anat);
r = dims(1);
c = dims(2);
nSlices = dims(3);
numAcross = min(4,nSlices);
numDown = ceil(nSlices/numAcross);
im = zeros(r*numDown,c*numAcross);
for sliceNum = 1:nSlices
    x = rem(sliceNum-1, numAcross)*r;
    y = floor((sliceNum-1)/numAcross)*c;
    im(y+1:y+r,x+1:x+c) = view.anat(:,:,sliceNum);
end
figure;
set(gcf,'Name','Anatomy Montage');
colormap(repmat([0:1/255:1]',1,3));
im = uint8(rescale2(im));
image(im);
axis image; axis off;
if exist('jpgPathStr', 'var')
    imFile = fullfile(jpgPathStr,'anat.jpg');
    imwrite(im, imFile, 'jpg', 'Quality', 100);
    disp(['Wrote montage from anatomies to ' imFile]);
end

% Display functionals
%
disp(['Extracting images from frame ' num2str(frameNum) ' of tSeries...']);
h = waitbar(0, ['Extracting ' num2str(nSlices) ' slices from ' ...
       num2str(length(scanNumList)) ' scans.']);

for scanNum = scanNumList
    slices = sliceList(view,scanNum);
    nSlices = length(slices);
    numAcross = min(4,nSlices);
    numDown = ceil(nSlices/numAcross);
    dims = sliceDims(view,scanNum);
    r = dims(1);
    c = dims(2);
    
    im = zeros(r*numDown,c*numAcross);
    for sliceNum = slices
        x = rem(sliceNum-1, numAcross)*c;
        y = floor((sliceNum-1)/numAcross)*r;
        tSeries = loadtSeries(view,scanNum,sliceNum);
        im(y+1:y+r,x+1:x+c) = reshape(tSeries(frameNum,:),dims);
        waitbar(sliceNum*scanNum/(length(scanNumList)*nSlices));
    end
    figure;
    set(gcf,'Name',['Scan ',num2str(scanNum),' Montage']);
    colormap(repmat([0:1/255:1]',1,3));
    im = uint8(rescale2(im));
    image(im);
    axis image; axis off;
    if exist('jpgPathStr', 'var')
        imFile = fullfile(jpgPathStr,['scan',num2str(scanNum),'.jpg']);
        imwrite(im, imFile, 'jpg', 'Quality', 100);
        disp(['Wrote ' imFile '.']);
    end
end
close(h);

return
