function view=setDisplayMode(view,mode)
% 
% view=setDisplayMode(view,mode)
% 
% Sets view.ui.displayMode.  Checks if necessary data is
% available for that displayMode.  If not, loads it if possible,
% or returns with warning message.
%
% mode: 'anat','co','amp','ph','wph','map'.
%
% djh, 1/98
%
% TODO: currently checks ~isempty(data), should also check size.

view = UpdateMapWindow(view);

switch mode
  case 'anat'
    if isempty(view.anat)
      view=loadAnat(view);
    end
  case 'co'
    if isempty(view.co)
      view=loadCorAnal(view);
    end
  case 'amp'
%     view = setAmplitudeWindow(view);
    if isempty(view.amp)
      view=loadCorAnal(view);
    end
  case 'ph'
    if isempty(view.ph)
      view=loadCorAnal(view);
    end
  case 'map'
    if isempty(view.map)
      warning('No parameter map. Use load parameter map from the File menu.');
    end
  otherwise
    myErrorDlg(['Unknown display mode: ',mode]);
end 

view.ui.displayMode=mode;

return;
