function view = selectCurROISlice(view)
%
%  view = selectROISlice(view)
%
% Changes to a slice in the VOLUME containing the currently
% selected ROI
%
% 12/10/98 rmk
% 2003.11.18 RFD: added code to also set the 3d cursor in mrMesh, if
% appropriate. Also, we now take the center of mass of the roi, rather than
% the first coord. -- Deleted said code (BW).

if ~strcmp(view.viewType,'Volume') & ~strcmp(view.viewType,'Gray')
    myErrorDlg('selectSliceCoords only for Volume view.');
end

if view.selectedROI==0
    myErrorDlg('No selected ROI.');
end

coords = view.ROIs(view.selectedROI).coords;
if(size(coords,2)==1)
    centerOfMass = coords;
else
    centerOfMass = round(mean(coords'))';
end

% Set the sliceNum editable text fields
for n=1:3
    set(view.ui.sliceNumFields(n),'String',num2str(centerOfMass(n)));
    if isfield(view, 'loc')
        view.loc = centerOfMass;
    end
end

return;
