function [view,im] = recompute3ViewImage(view,sliceNum,sliceOri);
%
% [view,im] = recompute3ViewImage(view,sliceNum,sliceOri);
%
% Recomputes the image for a volume 3 view. The main difference from
% recomputeImage is that the slice # and slice orientation can be input as
% arguments, rather than using the vals set for the view (curSlice(view) for a 
% 3-view is somewhat nonsensical).
%
% djh, sometime in '98
% djh, 2/2001. version 3.0 
% ras, hacked off of recomupteImage, 03/06/03
% Ress mentioned an improvement in recomputeImage since this branched off,
% which allows, for amplitude modes, the amp clip to be set using the
% mapMin/mapMax sliders. This is a good idea; I need to merge that feature
% in here. -ras, 03/04
if ~exist('sliceNum','var') sliceNum = 1;   end
if ~exist('sliceOri','var') sliceOri = 1;   end

% Initialize images
anatIm=[];
overlay=[];

% Get colormap, numGrays, numColors and clipMode
modeStr=['view.ui.',view.ui.displayMode,'Mode'];
mode = eval(modeStr);
cmap = mode.cmap;
numGrays = mode.numGrays;
numColors = mode.numColors;
clipMode = mode.clipMode;

% Get cothresh, phWindow, and mapWindow from sliders
cothresh = getCothresh(view);
phWindow = getPhWindow(view);
mapWindow = getMapWindow(view);

% Get anatClip from sliders
anatClip = getAnatClip(view);

% error check on slice number
if isnan(sliceNum) | sliceNum<1, sliceNum = 1; end
if sliceNum > size(view.anat, sliceOri)
    sliceNum = size(view.anat, sliceOri);
end

% Get anatomy image
switch sliceOri
    case 1, % axial
        anatIm = squeeze(view.anat(sliceNum,:,:));
    case 2, % coronal
        anatIm = squeeze(view.anat(:,sliceNum,:));
    case 3, % sagittal
        anatIm = view.anat(:,:,sliceNum);
end

% Get overlay
overlay = [];
if ~strcmp(view.ui.displayMode,'anat')
  overlay = cropCurSlice(view,view.ui.displayMode,sliceNum,sliceOri);
end

% Select pixels that satisfy cothresh, phWindow, and mapWindow
pts = [];
if ~isempty(overlay)
  pts = ones(size(overlay));
  curCo=cropCurSlice(view,'co',sliceNum,sliceOri);
  curPh=cropCurSlice(view,'ph',sliceNum,sliceOri);
  curMap=cropCurSlice(view,'map',sliceNum,sliceOri);
  if ~isempty(curCo) & cothresh>0
    ptsCo = curCo > cothresh;
    pts = pts & ptsCo;
  end
  if ~isempty(curPh)
    if diff(phWindow) > 0
      ptsPh = (curPh>=phWindow(1) & curPh<=phWindow(2));
    else
      ptsPh = (curPh>=phWindow(1) | curPh<=phWindow(2));
    end
    pts = pts & ptsPh;
  end
  if strcmp(view.ui.displayMode, 'amp')
    curAmp = cropCurSlice(view, 'amp');
    mnv = min(curAmp(:));
    mxv = max(curAmp(:));
    curMap = (curAmp - mnv) ./ (mxv - mnv);
  end  
  if ~isempty(curMap)
    ptsMap = (curMap>=mapWindow(1) & curMap<=mapWindow(2));
    pts = pts & ptsMap;
  end
end

% Rescale anatIm to [1:numGrays], anatClip determines the range
% of anatomy values that gets mapped to the available grayscales.
% If anatClip=[0,1] then there is no clipping and the entire
% range of anatomy values is scaled to the range of available gray
% scales.
minVal = double(min(anatIm(:)));
maxVal = double(max(anatIm(:)));
anatClipMin = min(anatClip)*(maxVal-minVal) + minVal;
anatClipMax = max(anatClip)*(maxVal-minVal) + minVal;
warning off;
anatIm = (rescale2(double(anatIm),[anatClipMin,anatClipMax],[1,numGrays]));
%keyboard

warning backtrace;

% Rescale overlay to [numGrays:numGrays+numColors-1]
if ~isempty(overlay)
   if strcmp(clipMode,'auto')
      if ~isempty(find(pts));
         overClipMin = min(overlay(pts));
         overClipMax = max(overlay(pts));
      else
         overClipMin = min(overlay(:));
         overClipMax = max(overlay(:));
      end
   else
      overClipMin = min(clipMode);
      overClipMax = max(clipMode);
   end
   overlay=rescale2(overlay,[overClipMin,overClipMax],...
      [numGrays+1,numGrays+numColors]);
end

% Combine overlay with anatomy image
if ~isempty(overlay)
   % Combine them in the usual way
   im = anatIm;
   indices = find(pts);
   im(indices) = overlay(indices);
   
elseif ~strcmp(view.ui.displayMode,'anat')
   % Perhaps data not loaded
   % (BW:  removed) Provide warning and show anatomy image.
   %myWarnDlg(['No overlay.  Check that ',...
   %      view.ui.displayMode,' is loaded.']);
   im = anatIm;
  
   
else
   % No overlay.  Just show anatomy image.
   im = anatIm;
   
end

% 2003.01.10 RFD: the following is no longer necessary- the uint8 data
% can't have any NaNs! Also, it caused problems in matlab versions <6.5.
% 2003.01.23 ARW: But without it, Matlab 6.5 fills in the Nans in the flat map as white.
% Do a version check for now and replace NaNs if >=R13
if (version('-release')>=13)
    indices = find(isnan(im));
    im(indices) = 1;
end

% Finally, set the view.ui.image field
%view.ui.image = uint8(double(im)-1);

view.ui.image = im;

if isempty(overlay)
   view.ui.cbarRange = [];
else
   view.ui.cbarRange = [overClipMin overClipMax];  
end

return;

