function nScans = numScans(view, dataType)
% Number of scans in current view (for selected data type, or 
% current data type if the second argument is omitted).
%
% nScans = numScans(view, [dataType])
%
% djh, 2/21/2001
% ras, 1/9/2006, added dataType argument
%
% New usage should be
%  nScans = viewGet(view, 'nscans', [dt]);
%
if nargin<2, dataType = view.curDataType; 
else,        dataType = existDataType(dataType);
end

global dataTYPES;

nScans = length(dataTYPES(dataType).scanParams);

return;

