function view = initHiddenInplane(dataType,scan,roi);
%  hiddenInplane = initHiddenInplane([dataType,scan,roi])
%
% Initialize an inplane view without starting a GUI. 
% Highly useful for scripting. If any of the optional
% args are specified, the hidden view will have that
% data type and scan selected, and that ROI loaded. 
% data types can be specified as names or numeric indices;
% ROIs can be specified as names or cells of names.
%
%
% djh, sometime in 1999
% ras, made name of hidden inplanes "hidden",
% this seems useful -- 04/05
% ras, 05/05, added curScan field
% ras, 06/05, ensures session is loaded, 
% mrGlobals is run; can specify data type,
% scan, and roi at outset.
% ras, 02/06: disbaled the notice that this was being initialized.
% I've found it a bit distracting; just a preference...
if ~exist('dataType','var') | isempty(dataType)
    dataType = 1;
end

if ~exist('scan','var') | isempty(scan)
    scan = 1;
end

% disp('Initializing HIDDEN Inplane view')

evalin('base','mrGlobals');
evalin('base','loadSession');
evalin('base','HOMEDIR = pwd;');

view.name='hidden';
view.viewType='Inplane';
view.subdir='Inplane';

% Initialize slots for co, amp, and ph
view.co = [];
view.amp = [];
view.ph = [];
view.map = [];
view.mapName = '';

% Initialize slots for tSeries
view.tSeries = [];
view.tSeriesScan = NaN;
view.tSeriesSlice = NaN;

% Initialize ROIs
view.ROIs = [];
view.selectedROI = 0;

% Initialize curDataType
if isnumeric(dataType),
    view.curDataType = dataType;
elseif ischar(dataType),
    view.curDataType = existDataType(dataType);
end

% Initialize curScan
view.curScan = scan;

% load any ROIs specified
if exist('roi','var') & ~isempty(roi)
    view = loadROI(view,roi);
end

return
