function flat = getSelectedFlat
%
% Return the currently-selected FLAT view, if it exists.
%
%
% Don't know who wrote this? Commented by ras, 05/05.
% Also added the manual search for a view if selectedFLAT is
% empty.
mrGlobals
if ieNotDefined('FLAT')
    warning('No selected Flat: FLAT variable is not defined.');
    flat = [];
    return
end

if ~isempty(selectedFLAT)
    flat = FLAT{selectedFLAT};
else
    flatList=cellfind(FLAT);
    if (length(flatList)>=1)
        selectedFLAT=flatList(1);
        flat=FLAT{selectedFLAT};
    else
        flat = [];
    end
end

return
