function pathStr = dataDir(view)
%
%  pathStr = dataDir(view)
%
% Returns the directory where data 
% for a given data type should (if you're
% nice and neat) be stored. E.g., if you're
% in an inplane view and looking at average
% tSeries, the dataDir would be
% HOMEDIR/Inplane/Averages/
%
% If this directory doesn't exist, make it!
%
% djh, 2/2001
global dataTYPES HOMEDIR

if isempty(HOMEDIR)
    HOMEDIR = pwd;
end
% dir = homeDir(view); -- BW ... just an opinion
                          % ras -- reversed this opinion, more decisively,
                          % below 

dir = viewGet(view,'subdir');
curDataType = viewGet(view,'currentDataType');

% Need a dtGet and dtSet
subDir = dataTYPES(curDataType).name;
pathStr = fullfile(HOMEDIR,dir,subDir);

if ~exist(pathStr,'dir'),  mkdir(dir,subDir);  end

return;
