function slice = cropCurAnatSlice(view,curSlice)
%
% function slice = cropCurAnatSlice(view,[slice])
%
% Pulls slice from view.anat. Defaults to 
% current slice.
%
% djh, 7/98
% ras, 01/05 added slice as input arg
if ieNotDefined('curSlice')
	% Get curSlice from ui
	curSlice = getCurSlice(view);
end

dims = viewSize(view);

switch view.viewType

  case 'Inplane'
    if ~isempty(view.anat)
      slice = view.anat(:,:,curSlice);
    else
      disp('Warning: Anatomies not loaded');
      slice = zeros(dims(1:2));
    end
    
  case {'Volume','Gray','generalGray'}
    curSliceOri = getCurSliceOri(view);
    if ~isempty(view.anat)
      switch curSliceOri
        case 1
          slice = squeeze(view.anat(curSlice,:,:));
	case 2
	  slice = squeeze(view.anat(:,curSlice,:));
	case 3
          slice = view.anat(:,:,curSlice);
      end
    else
      disp('Warning: Anatomies not loaded');
      switch curSliceOri
        case 1
	  slice = zeros(dims(2:3));
	case 2
	  slice = zeros([dims(1) dims(3)]);
	case 3
	  slice = zeros(dims(1:2));
      end
    end

  case {'Flat','FlatLevel'}
    if ~isempty(view.anat)
      slice = view.anat(:,:,curSlice);
    else
      disp('Warning: Anatomies not loaded');
      slice = zeros(dims(1:2));
    end
    
end

return
