function view = refreshMontageView(view,recomputeFlag)
% 
% view = refreshMontageView(view,recomputeFlag)
% 
% For inplane montage views:
% Refresh the screen given the current state of the ui
% parameters.  This is a key script.  It is used to put up all
% the different viewTypes of images under the View menu.
%
% view.ui.displayMode must be a string (either 'anat', 'co',
% 'amp', 'ph, or 'map') corresponding to the available
% displayModes (anatMode, coMode, ampMode, phMode, and mapMode).
% Each displays a different overlay on the anatomy, with a
% different colormap.
%
% Each displayMode has a cmap field (e.g., view.ui.anatMode.cmap).
%
% Each displayMode also has a clipMode field (e.g.,
% view.ui.anaMode.clipMode) that determines clipping of the
% overlay image values to fill the range of available colors.  The
% clipMode can be either 'auto' or [clipMin clipMax].  If 'auto',
% uses overlayClip sliders to determine clipping.  If [clipMin
% clipMax], uses those values instead.  For some of the
% displayModes ('ph') fixed clipping usually makes sense because
% we want certain values (e.g., 0 phase) to always correspond to
% the same color (e.g., red) regardless of the cothresh and
% phWindow.
%
% recomputeFlag: if nonzero (the default), recomputes the uint8
% image.  Otherwise, uses the image stored in view.ui.image.
% 
% ras 09/04: broken off refreshView.
if ~exist('recomputeFlag','var'), recomputeFlag=1; end

% Make this one the selectedInplane, selectedVolume, or selectedFlat
if iscell(view), selectView(view); end

% Set window title
% Check for sessionCode - this should have been set in openxxxxWindow but
% some other programs (like mrAlign) don't beshave properly.
if (~isfield(view,'sessionCode'))
    view.sessionCode=pwd;
end

% Get colormap, numGrays, numColors and clipMode
modeName = viewGet(view,'displayMode');
str = [modeName 'Mode'];

% Make sure the phMode, or ampMode structure exists.  If not, then set them
% to the default values.
if ~checkfields(view,'ui',str), view=resetDisplayModes(view); end

% Here is the mode, get the relevant parameters.
modeStr=['view.ui.',str];
mode = eval(modeStr);
cmap = mode.cmap;
numGrays = mode.numGrays;
numColors = mode.numColors;
clipMode = mode.clipMode;

if (recomputeFlag | isempty(view.ui.image))
    firstSlice = getCurSlice(view);
    nSlices = get(view.ui.montageSize.sliderHandle,'Value');
    slices = [firstSlice:firstSlice+nSlices-1];
    slices = slices(slices <= numSlices(view));
    zoom = view.ui.zoom;
    [img, view] = inplaneMontage(view,slices,modeName,zoom);
end

% Select the window
set(0,'CurrentFigure',view.ui.windowHandle);

% Update annotation string
set(view.ui.annotationHandle,'string',annotation(view,getCurScan(view)));

% % put up the image
% imshow(view.ui.image);

% Draw colorbar
if isempty(view.ui.cbarRange)
    setColorBar(view,'off',[numGrays+1,numGrays+numColors]);
else
    setColorBar(view,'on',[numGrays+1,numGrays+numColors]);
end

% add a fancy GUI callback
htmp = get(gca,'Children');
set(htmp,'ButtonDownFcn',sprintf('%s = adjustMRImage(%s);',view.name,view.name));

% Erase old ROI lines
htmp = findobj('Parent',view.ui.mainAxisHandle,'Type','line');
delete(htmp);

% Draw ROIs
if view.ui.showROIs > 0,     drawROIsMontage(view);
elseif view.ui.showROIs < 0, drawROIsPerimMontage(view);
end

return