function [selectedSlices, nrows, ncols] = montageDims(view);
%
% [selectedSlices, nrows, ncols] = montageDims(view);
%
% Return the dimensions of a montage view (for inplanes, flat
% levels). selectedSlices is a vector of the slices currently
% being displayed in the montage, nrows and ncols are the rows
% and columns in the image. Takes into account an optional
% 'columnMajor' setting, so montages can run across rows 
% or columns (though the interface to set this isn't written
% yet).
% 
% ras, 05/05
viewType = viewGet(view,'viewType');
ui = viewGet(view,'ui');
switch viewType
    case 'Inplane',
        firstSlice = getCurSlice(view);
        nSlices = get(ui.montageSize.sliderHandle,'Value');
        selectedSlices = firstSlice:firstSlice+nSlices-1;
    case 'Flat',
        selectedSlices = getFlatLevelSlices(view);    
        nSlices = length(selectedSlices);
    otherwise,
        error('drawROIsMontage: no support for this view type.');
end

selectedSlices = selectedSlices(selectedSlices <= numSlices(view));
nSlices = length(selectedSlices);

if isfield(view.ui,'settings') & isfield(view.ui.settings,'columnMajor') ...
    & view.ui.settings.columnMajor==1
    % montage is column-major
	ncols = ceil(sqrt(nSlices));
	nrows = ceil(nSlices/ncols);
else
    % montage is row-major
	nrows = ceil(sqrt(length(selectedSlices)));
	ncols = ceil(nSlices/nrows);
end

return
