function view = refreshFlatLevelView(view,recomputeFlag);
% 
% view = refreshFlatLevelView(view,recomputeFlag);
% 
% This is a version of refreshView that works on the
% Flat Across-Gray-Levels View. There are 2 main reasons
% I'm breaking it off into a separate function:
%
%   1) It allows for working off a mosaic of several layers
%      at once, which may be useful for things like inplane
%      views but would also make the refreshView code confusing;
%
%   2) It's still being tested out, so it's structure is likely
%      to change.
%
% But basically, it refreshes the flat multi view interface
% based off the settings in the UI controls.
% 
% ras, 08/04, off refreshView

if ~exist('recomputeFlag','var'), recomputeFlag=1; end

% Make this one the selectedInplane, selectedVolume, or selectedFlat
if iscell(view), selectView(view); end

% Set window title
% Check for sessionCode - this should have been set in openxxxxWindow but
% some other programs (like mrAlign) don't beshave properly.
if (~isfield(view,'sessionCode'))
    view.sessionCode=pwd;
end

ui = viewGet(view,'ui');

% Get colormap, numGrays, numColors and clipMode
str = [view.ui.displayMode,'Mode'];

% Make sure the phMode, or ampMode structure exists.  If not, then set them
% to the default values.
if ~checkfields(view,'ui',str), view=resetDisplayModes(view); end

% Here is the mode, get the relevant parameters.
modeStr=['view.ui.',str];
mode = eval(modeStr);
cmap = mode.cmap;
numGrays = mode.numGrays;
numColors = mode.numColors;
clipMode = mode.clipMode;

% get/set flat rotations
[rotations,flipLR] = getFlatRotations(view);  

if (~(recomputeFlag==2)) % Only set when the hemisphere changes
    % Retreive the imageRotation from the UI
    thisRotation = getImageRotate(view);
        
    % Set the corresponding value in degrees in FLAT.imageRotateDegrees
    rotations(getCurSlice(view)) = thisRotation*(180/pi);
end

view = setFlatRotations(view,rotations,flipLR);

% recompute the image if selected
if (recomputeFlag | isempty(view.ui.image))
    view = recomputeFlatLevelImage(view);
end

% Select the window
set(0,'CurrentFigure',view.ui.windowHandle);

% Update annotation string
set(view.ui.annotationHandle,'string',annotation(view,getCurScan(view)));

% Display final image
dispMode = sprintf('%sMode',viewGet(view,'displayMode'));
cmap = view.ui.(dispMode).cmap;
imshow(view.ui.image);
colormap(cmap);

% Draw colorbar
if isempty(view.ui.cbarRange)
    setColorBar(view,'off',[numGrays+1,numGrays+numColors]);
else
    setColorBar(view,'on',[numGrays+1,numGrays+numColors]);
end

% Draw ROIs
if view.ui.showROIs > 0,     drawROIsMontage(view);
elseif view.ui.showROIs < 0, drawROIsPerimMontage(view);
end

return
