function removeDataType(dataTypeName);
%
%     removeDataType(dataTypeName);
% 
% Remove a dataType from mrSESSION and updates open views appropriately.
% This routine depends on dataTYPES being a global variable.
%
% djh, 3/2001
mrGlobals
if strcmp(dataTypeName,'Original')
    error('removeDataType: Cannot remove original dataType.\n');
end
ndataType = existDataType(dataTypeName);

% If the dataType exists, (1) remove it from mrSESSION, (2) remove it from the
% popup menu options, (3) adjust the value of the curDataType
% and (4) check whether or not to delete the corresponding subdirectories
if ndataType
    % Adjust the mrSESSION structure
    fprintf('removeDataType: removing %s dataType\n',dataTypeName);
    other = setdiff(1:length(dataTYPES),ndataType);
    dataTYPES = dataTYPES(other);
    
    saveSession(1);

    if ndataType > 1 % should always happen, except unusual circumstances
        ndataType = ndataType - 1;
    end
    
    % Delete all the data files for this dataType
    cleanDataType(dataTypeName,1);
    
    % Loop through the open views, switch their curDataType appropriately, 
    % and update the dataType popups
    INPLANE = resetDataTypes(INPLANE, ndataType);
    VOLUME = resetDataTypes(VOLUME, ndataType);
    FLAT = resetDataTypes(FLAT, ndataType);
else
    fprintf('removeDataType: %s dataType not found.\n',dataTypeName);
end
return;
