function groupName = groupScans(view,scanList,groupName)
%
% dataTypeName = groupScans(view,[scanList],[dataTypeName])
% 
% Author: Wandell
% Purpose:
%    Select scans from the Original series and make a new dataType
%    containing a subset (unaveraged).  For example, if a scan contains
%    retinotopies and color, you might want them grouped into two different
%    sets.  This occupies more space, but it could make life more
%    efficient for loading and thinking.
%
%    Generally follows the logic in averageTSeries
%
% scanList: scans to be grouped into the new type. Default: prompt user.
% dataTypeName: If omitted, the user is prompted for the name of the group.
% 
% ras 01/05: added option to enter data type name as an input arg.
% ras 10/05: appends scans to specified group if it already exists.
mrGlobals

if (~exist('scanList','var') | isempty(scanList)), scanList = er_selectScans(view); end
if isempty(scanList), return; end

% if ~strcmp(view.viewType,'Inplane'), error('Grouping is only applied in the Inplane view'); end

if ieNotDefined('groupName')
    % Select a name for the group
	curTypeNames = sprintf('%s ',dataTYPES(:).name);
	groupName = mrSelectName(curTypeNames);
end

% Add the name to the dataTYPES
if isempty(groupName)
    return;
elseif existDataType(groupName)
    % just append, below
else
    addDataType(groupName); 
end

hiddenView = initHiddenInplane;
hiddenView = selectDataType(hiddenView,existDataType(groupName));

% Set dataTYPES.scanParams so that new group scan has the same params as
% the 1st scan on scanList.
newScanNum = length(scanList);
ndataType = hiddenView.curDataType;
if existDataType(groupName)
    firstNewScan = length(dataTYPES(ndataType).scanParams)+1;
else
    firstNewScan = 1;
end
newScanRange = firstNewScan:firstNewScan+newScanNum-1;

for ii = 1:length(newScanRange)
    tgt = newScanRange(ii);
    dataTYPES(ndataType).scanParams(tgt) = dataTYPES(view.curDataType).scanParams(scanList(ii));
    dataTYPES(ndataType).blockedAnalysisParams(tgt) = dataTYPES(view.curDataType).blockedAnalysisParams(scanList(ii));
    dataTYPES(ndataType).eventAnalysisParams(tgt) = dataTYPES(view.curDataType).eventAnalysisParams(scanList(ii));
    dataTYPES(ndataType).scanParams(tgt).annotation = dataTYPES(view.curDataType).scanParams(scanList(ii)).annotation;
end

saveSession

% Get the tSeries directory for this dataType 
% (make the directory if it doesn't already exist).
tseriesdir = tSeriesDir(hiddenView);

% Make the Scan subdirectory for the new tSeries (if it doesn't exist)
scandir = fullfile(tseriesdir,['Scan',num2str(newScanNum)]);
if ~exist(scandir,'dir')
    mkdir(tseriesdir,['Scan',num2str(newScanNum)]);
end

% Double loop through slices and scans in scanList
nSlices = length(sliceList(view,scanList(1)));
wbar = waitbar(0,'Copying tseries...');
nTseries = newScanNum*nSlices;

for  iScan = 1:length(newScanRange)
    % For each scan... copy the tseries.
    for iSlice = 1:nSlices
        % For each slice...
        tgt = newScanRange(iScan);
        tSeries = loadtSeries(view, scanList(iScan), iSlice);
        savetSeries(tSeries,hiddenView,tgt,iSlice);
        waitbar((nSlices*(iScan-1) + iSlice)/nTseries,wbar)
    end
end
close(wbar);

% for event-related scans, group the scans
er_groupScans(view,newScanRange,2,existDataType(groupName));

% Loop through the open views, switch their curDataType appropriately, 
% and update the dataType popups
INPLANE = resetDataTypes(INPLANE,ndataType);
VOLUME  = resetDataTypes(VOLUME,ndataType);
FLAT    = resetDataTypes(FLAT,ndataType);

return;


%---------------------------------------------
function newName = mrSelectName(curNames)
%
% Select a new name for some object.  Show the user the current names,
% generally to be avoided.
%

prompt={sprintf('Current  names: %s',curNames)};
dlgTitle='Input new name';
lineNo=1;
def{1} = sprintf('New');

newName = inputdlg(prompt,dlgTitle,lineNo,def);
newName = char(newName);

return;

