function AX = normAxes(obj,AX);
% normAxes: set all axes within a figure to have the same axes.
% 
% AX = normAxes(obj) sets all axes that are children of 
% the specified object to have the same, maximal axes. Returns
% AX, these maximal axes. obj defaults to gcf.
%
% If you only want to normalize some axes within the figure
% (E.g., for making figure papers), you can pass obj as a 
% vector of handles to those axes.
%
% You can also manually specify the axis bounds
% by specifying AX as a second argument. The format
% is [xmin xmax ymin ymax].
%
% ras 06/05.
if nargin==0, obj = gcf; end

if length(obj)==1
    haxes = findobj('Type','axes','Parent',obj);
else
    haxes = obj;
end

if isempty(haxes), AX = []; return; end

if ~exist('AX','var') | isempty(AX)
    for i = 1:length(haxes)
        axes(haxes(i));
        a(i,:) = axis;
    end
    AX = [min(a(:,1)) max(a(:,2)) min(a(:,3)) max(a(:,4))];
end

for i = 1:length(haxes)
    axes(haxes(i));
    axis(AX);
end

return
