function polarPlot(Z,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8)
% polarPlot(Z,params)
%   creates a polar plot using the parameters 
%   determined by the structure 'params'.  
%
% PolarPlot(Z,'PropertyName1',PropertyValue1,'PropertyName2',... );
%   creates a polar plot using the property values and names
%
%   default fields of params or properties:
%      params.grid            = 'on';
%      params.line            = 'on';
%      params.gridColor       = [0.6,0.6,0.6];
%      params.gridLineWidth   = 1;
%      params.fontSize        = 12;
%      params.symbol          = 'os^dp';
%      params.size            = 20;;
%      params.color           = 'k';
%      params.fillColor       = [1,1,1;0.6,0.6,0.6;0,0,0];
%      params.lineWidth       = 2;
%      params.backgroundColor = 'w';
%      params.maxAmp          = ceil(max(abs(Z(:)))*10)/10;
%      params.ringTicks       = [0:0.1:defParams.maxAmp];
%
%  fillColor loops through the COLUMNS of Z
%  symbols loop through the ROWS of Z
%
%  Example:
%  [x,y] = meshgrid(linspace(0,2*pi,11),linspace(0,2*pi,11));
%  Z = x.*exp(sqrt(-1)*(y+x/5));
%  polarPlot(Z,'fillColor',hsv(11),'grid','off','line','off','size',30)

% 4/9/98 gmb wrote it.

defParams.grid            = 'on';
defParams.line            = 'on';
defParams.gridColor       = [0.6,0.6,0.6];
defParams.gridLineWidth   = 1;
defParams.fontSize        = 12;
defParams.symbol          = 'os^dp';
defParams.size            = 20;;
defParams.color           = 'k';
defParams.fillColor       = [1,1,1;0.6,0.6,0.6;0,0,0];
defParams.lineWidth       = 2;
defParams.backgroundColor = 'w';
defParams.maxAmp          = ceil(max(abs(Z(:)))*10)/10;
defParams.ringTicks       = [0:0.1:defParams.maxAmp];

%set up default parameters
if ~exist('arg1')
  params = [];
else
  params = arg1;
end

%If a string is passed as second argument it must be a property name
%so build the params file from the arguments
if strcmp(class(params),'char')  
  for arg=1:2:nargin-1
    estr =['propertyName = arg',int2str(arg),';'];   eval(estr)
    estr = ['params.',propertyName,' = arg',int2str(arg+1),';'];
    eval(estr)
  end
end

%tack default fields onto params structure
fieldNames = fieldnames(defParams);
for fieldNum = 1:size(fieldNames,1)
  fieldName = cell2struct(fieldNames(fieldNum),'x'); %why is there no 'cell2char'?
  if ~isfield(params,fieldName.x)                    %this is terribly lame
    estr = ['params.',fieldName.x,' = defParams.',fieldName.x,';'];
    eval(estr);
  end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Ready to plot

set(gcf,'Color',params.backgroundColor);

hold on
if strcmp(params.grid,'on')
  %radial lines
  maxRad = max(params.ringTicks); 
  for i=linspace(0,pi,5);
    line([-maxRad*cos(i),maxRad*cos(i)],[-maxRad*sin(i),maxRad*sin(i)],...
	'Color',params.gridColor,'lineWidth',params.gridLineWidth);
  end
  
  %concentric circles.
  arg = linspace(0,pi*2,64);
  for i=params.ringTicks(2:length(params.ringTicks));
    x = i*cos(arg);
    y = i*sin(arg);
    plot(x,y,'Color',params.gridColor,'lineWidth',params.gridLineWidth);
  end
  
  %labels
  dx = 0.075*params.maxAmp;
  for i=params.ringTicks(2:length(params.ringTicks));
    text(dx,i+dx,...
	sprintf('%3.2f',i),'Color',params.gridColor,'FontSize',params.fontSize);
  end
end

%hack:  place four white points in the corners to fix image size

plot(params.maxAmp*exp(sqrt(-1)*[45,135,225,315]*pi/180),'w.')


%loop through the columns of Z

%lines first
if strcmp(params.line,'on')
  for i=1:size(Z,2)
    color = params.color(mod(i-1,length(params.color))+1);
    for j=1:size(Z,1)
      plot([0,real(Z(j,i))],[0,imag(Z(j,i))],color,...
	  'LineWidth',params.lineWidth)
    end
  end
end

%then symbols
for i=1:size(Z,1)
  symbol = params.symbol(mod(i-1,length(params.symbol))+1);
  color = params.color(mod(i-1,length(params.color))+1);
  for j=1:size(Z,2)
    fillColor = params.fillColor(mod(j-1,size(params.fillColor,1))+1,:);
    
    plot(real(Z(i,j)),imag(Z(i,j)),[symbol,color],...
      'LineWidth',params.lineWidth,...
      'MarkerFaceColor',fillColor,...
      'MarkerSize',params.size)
  end
end

axis off
axis equal

return


