function outStruct = mergeStructures(firstStruct,secondStruct)
%outStruct = mergeStructures(firstStruct,secondStruct)
%
%returns a structure with fields from both input structures.
%If both input structures have the same fields, the secondStruct
%fields overwrite the firstStruct fields.

outStruct = firstStruct;

if ~isempty(secondStruct)
  fieldNames = fieldnames(secondStruct);
  for i = 1:length(fieldNames)
    field = getfield(secondStruct, fieldNames{i});
    outStruct = setfield(outStruct, fieldNames{i}, field);
  end
end


