function coords = combineCoords(coords1,coords2,action)
%
% coords = combineCoords(coords1,coords2)
%
% Combines coords1 and coords2, removing duplicates, used for
% example to merge ROI coordinates into one big ROI.
%
% coords, coords1, and coords2: 3xN arrays of (y,x,z) coordinates
% dims is size of volume
%
% rmk 10/30/98 
% djh, 2/2001, updated to use intersect(coords1,coords2,'rows')
% ras, 04/10/05, deals w/ empty coords

% Matlab functions work on rows, not cols
coords1 = coords1';
coords2 = coords2';
	
% made a little more complex, in case we 
% run into empty sets of coords:
if isempty(coords1)
	switch lower(action)
      case 'intersection'
         coords = [];
      case 'union'
         coords = coords2;
      case 'xor'
         coords = coords2;
      case 'a not b'
         coords = [];
	end
elseif isempty(coords2)
	switch lower(action)
      case 'intersection'
         coords = [];
      case 'union'
         coords = coords1;
      case 'xor'
         coords = coords1;
      case 'a not b'
         coords = coords1;
	end
else
	switch lower(action)
      case 'intersection'
         coords = intersect(coords1,coords2,'rows');
      case 'union'
         coords = union(coords1,coords2,'rows');
      case 'xor'
         coords = setxor(coords1,coords2,'rows');
      case 'a not b'
         coords = setdiff(coords1,coords2,'rows');
	end
end

% Transpose back to 3xN
coords = coords';

return

% old code:
%
% indices1 = coords2Indices(coords1,dims);
% indices2 = coords2Indices(coords2,dims);
% 
% switch action
%   case 'Intersection'
%      indices = intersect(indices1,indices2);
%   case 'Union'
%      indices = union(indices1,indices2);
%   case 'XOR'
%      indicesA = setdiff(indices1,indices2);
%      indicesB = setdiff(indices2,indices1);
%      indices=union(indicesA,indicesB);
%   case 'A not B'
%      indices = setdiff(indices1,indices2);  
% end
% 
% coords = indices2Coords(indices,dims);
