function newCoords = canOri2CurOri(view,coords)
%
% newCoords = canOri2CurOri(view,coords)
%
% djh and baw, 7/98
% ras, 04/05, deals w/ radiological conventions

newCoords = [];
if ~isempty(coords)
  if strcmp(view.viewType,'Volume') | strcmp(view.viewType,'Gray')
    dims = viewSize(view);
    curSliceOri = getCurSliceOri(view);
    switch curSliceOri
      case 1, % axial slice
        newCoords = coords([2 3 1],:);
        if isfield(view.ui,'flipLR') & view.ui.flipLR==1
            newCoords(2,:) = dims(3) - newCoords(2,:);
        end
      case 2, % coronal slice
        newCoords = coords([1 3 2],:);
        if isfield(view.ui,'flipLR') & view.ui.flipLR==1
            newCoords(2,:) = dims(3) - newCoords(2,:);
        end
      case 3, % sagittal slice
        newCoords = coords;
      otherwise
        myErrorDlg('Stupid slice orientation');
      end
  else
    newCoords = coords;
  end
end

return
