% PennMsakeMrLoadRetSession
%
% This script converts data from Analyze format to a mrLoadRet session.
%
% 5/15/03  dhb  Worked on cleaning up this code.  It came originally
%               from the Stanford group and was worked on extensively at
%               Penn by ggchen.
%          dhb  Renamed with Penn prefix.  It seems important not to
%               different versions of this same routine.
% 5/16/03  dhb  Rename M -> mrSESSION.
%          dhb  More direct conversion to mrLoadRet3 format.

% Clean out anything that is hanging around.
clear all;

% Standard mr global initialization
mrGlobals

% Diagnostic messages?
VERBOSE = 1;

% Prompt user for parameter file. This must live in the current directory.
defaultParameterFilename = 'mrLoadRetParams';
parameterFilename = input(sprintf('Enter parameter filename [%s]: ',defaultParameterFilename),'s');
if (isempty(parameterFilename))
    parameterFilename = defaultParameterFilename;
end

% Check that the parameter file exists in pwd.  Exit with error if not.
if (~exist(parameterFilename,'file'))
    error(sprintf('Specified parameter file %s\n\tdoes not exist in current directory %s\n',...
        parameterFilename,pwd));
end

% Run the parameter file to set up the variables
eval([parameterFilename]);

% Get image inforamtion from  anatomical image file
anatinFileRoot=fullfile(anatFileBaseDir,anatomyInplaneDir,anatomyRootName);
Va=spm_vol([anatinFileRoot '.hdr']);
mrSESSION.voxelSize=[Va.mat(1,1) Va.mat(2,2) Va.mat(3,3)];    % anatomical voxel size in mm/vox
mrSESSION.fullInplaneSize=[Va.dim(1) Va.dim(2)];              % anatomical data encoding matrix size in pixels
mrSESSION.inplaneCrop=[1,1;Va.dim(1),Va.dim(2)];              % subrectangle of anatomical data to use, no crop
mrSESSION.cropInplaneSize=mrSESSION.inplaneCrop(2,:)-mrSESSION.inplaneCrop(1,:)+1;

% Get the functional image info by reading one of 'em
funtinFileRoot=fullfile(funcFileBaseDir,sourceSubDirArray{1},...
    [sourceRootArray{1} sprintf('%03d',sourceRootFirstFrames(1))]);
Vf=spm_vol([funtinFileRoot '.hdr']);
mrSESSION.fvoxelSize=[Vf.mat(1,1) Vf.mat(2,2) Vf.mat(3,3)];     % functional  voxel size in mm/vox
mrSESSION.fullSize= [Vf.dim(1) Vf.dim(2)];                      % functional data encoding matrix size in pixels
mrSESSION.tseriesCrop=[1 1; Vf.dim(1) Vf.dim(2)];               % subrectangle of functional data to use, no crop
mrSESSION.fnSlices=Vf.dim(3);                                   % number of functional slices
mrSESSION.FOV= mrSESSION.fvoxelSize(1:2).*mrSESSION.fullSize;                   % function inplane FOV in mm

% Other parameters.
mrSESSION.totalFrames= mrSESSION.nFrames+mrSESSION.junkFirstFrames+mrSESSION.junkLastFrames;    % totalFrames
mrSESSION.cropTSeriesSize=mrSESSION.tseriesCrop(2,:)-mrSESSION.tseriesCrop(1,:)+1;      % functional crop size
mrSESSION.types.name='Original';                                        % Directory
mrSESSION.types.nScans= mrSESSION.nScans;                                       % # of scans
mrSESSION.curType=1;                                                    % don't know
mrSESSION.screenSaveSize=[0 0];                                         % just a dummy

% Change name of M structure to mrSESSION for mrLoadRet 3 convention.
mrSESSION.nSlices = mrSESSION.fnSlices;         % functional slices

% Fill in a bunch of information for mrLoadRet
nFunctionals=mrSESSION.nScans;
for t=1:nFunctionals
    mrSESSION.reconParams(t).totalFrames=mrSESSION.totalFrames;
    mrSESSION.reconParams(t).FOV=mrSESSION.FOV;
    mrSESSION.reconParams(t).nSlices=mrSESSION.fnSlices;
    mrSESSION.reconParams(t).fullSize=mrSESSION.fullSize;
    mrSESSION.reconParams(t).sliceThickness=mrSESSION.fvoxelSize(3);
    mrSESSION.reconParams(t).freqEncodeMatSize=mrSESSION.fullSize(1);
    mrSESSION.reconParams(t).frameRate=mrSESSION.frameRate*1000;
    mrSESSION.reconParams(t).inplaneVoxelSize=mrSESSION.fvoxelSize;
    mrSESSION.reconParams(t).date=datestr(now);  
end

% Now make mrLoadRet directory.  If it is already
% there, check before overwrite.  The overwrite completely
% clears what whas there before.
if (exist(mrSESSION.homeDir,'dir'))
    while (1)
        overwrite = [];
        overwrite = input(sprintf('Directory %s already exists.\nReally overwrite? (y/n): ',...
            mrSESSION.homeDir),'s');
        if (strcmp(overwrite,'y'))
            eval(['!rm -rf ' mrSESSION.homeDir]);
            mkdir(mrSESSION.homeDir);
            break;
        elseif (strcmp(overwrite,'n'))
            return;
        end
    end
else
    mkdir(mrSESSION.homeDir);
end
chdir(mrSESSION.homeDir);
save ('mrSESSION.mat','mrSESSION');     % save mrSESSION.
a=mkdir('Inplane');                     % holds data in 'slice' format
a=mkdir('Flat');                        % holds data in 3D restricted to the cortical gray matter
a=mkdir('Volume');                      % barely used. Holds data in 3D 
a=mkdir('Raw');                         % original FID files, IRRARE files etc.
a=mkdir('Inplane/ROIs');                % regions of interest 
a=mkdir('Inplane/Original/TSeries');    % the converted tSeries data go here
a=mkdir('Inplane/TSeries');             % we're not sure what goes here
a=mkdir('Gray/ROIs');
a=mkdir('Flat/ROIs');
tSerDir=['Inplane/Original/TSeries/'];

% Generate the anat.mat file. This takes the input analyze format data and
% puts it into the appropriate MATLAB format for mrLoadRet.
%
% Get structural and save it in MATLAB format.
anat=PennAnalyze2mrLoadRetInplanes(fullfile(anatFileBaseDir,anatomyInplaneDir,anatomyRootName),...
    'Inplane/anat.mat');
if (anatomyRotate ~= 0)
	for t=1:nSlices
        anat(:,:,t)=rot90(anat(:,:,t),anatomyRotate);
	end
end
save('Inplane/anat.mat','anat');

% Import the functional data
for thisScan=1:mrSESSION.nScans
    % Create directory where converted TSeries go.
    thisTSerDir=fullfile(tSerDir,['Scan',int2str(thisScan)]);
    a=mkdir(thisTSerDir);
    
    % Figure out where the data come from  
    sourceRoot=fullfile(funcFileBaseDir,sourceSubDirArray{thisScan},sourceRootArray{thisScan});  
    
    % Get the functional image stack.  As a side effect, this fills up the
    % 'Original' directory with the appropriate .dat files, which will be
    % converted to .mat file by convert2to3
    PennAnalyze2mrLoadRetTSeries(sourceRoot,[thisTSerDir '/'],mrSESSION.nFrames,...
        sourceRootFirstFrames(thisScan),...
        functionalRotate,functionalScale,functionalFlip,VERBOSE);
       
    fprintf('\nDone scan %d (directory %s)\n',thisScan,sourceSubDirArray{thisScan}); 
end
fprintf(1,'Processed total scans: %d\n',mrSESSION.nScans);  

% Do remainder of 2->3 conversion.  This could gradually be
% migrated so that we do it in version 3 from the start.
PennConvert2To3;

% Return to directory from whence we came
cd ..