function view = setFlatRotations(view,rotations,flipLR)
%
% view = setFlatRotations(view,rotations,flipLR)
%
% Set rotation field in FLAT
% AND also set the flat slider

if (~strcmp(view.viewType,'Flat'))
    error('setFlatRotation called for non-flat view');
end

if (exist('rotations','var'))
    view.rotateImageDegrees=rotations;
end

if (exist('flipLR','var'))
    view.flipLR=flipLR;
end

curSlice=getCurSlice(view);

% Set the slider
setImageRotate(view,rotations(curSlice)/(180/pi));

