function view=makeVolSliceUI(view)
%Installs orientation buttons and edit fields for slice numbers
%
% view=makeVolSliceUI(view)
%
% Installs:
%   slice orientation buttons (axi=button 1, cor=button 2, sag=button 3)
%   editable text fields for slice numbers
%   prev and next push buttons
%
% djh, 7/98

% Slice orientation buttons
width = .1;
height = .05;
bot= .01;
buttonLabels=['Axi'; 'Cor'; 'Sag'];
for b = 1:3
  left = .25*(b-1) + 0.1;
  % Callback:
  %   selectButton(view.ui.sliceOriButtons,b);
  %   view=refreshScreen(view);
  callbackStr = ...
      ['selectButton(',view.name,'.ui.sliceOriButtons,',num2str(b),'); ',...
	  view.name,'=refreshScreen(',view.name,');'];
  view.ui.sliceOriButtons(b) = ...
      uicontrol('Style','radiobutton',...
      'String',buttonLabels(b,:),...
      'Units','normalized',...
      'Position',[left,bot,width,height],...
      'Callback', callbackStr);
end

% Slice num fields
width = .1;
height = .05;
bot= .01;sz= viewSize(view);
for b = 1:3
  left = .25*(b-1) + .2;
  % Callback:
  %   sliceNum=str2num(get(view.ui.sliceNumFields(b),'String'));
  %   volSize=viewSize(view);
  %   sliceNum=clip(sliceNum,1,volSize(b));
  %   set(view.ui.sliceNumFields(b),'String',num2str(sliceNum));
  %   clear sliceNum volSize;
  %   view=refreshScreen(view);
  bstr=num2str(b);
  callbackStr = ...
      ['sliceNum=str2num(get(',view.name,'.ui.sliceNumFields(',bstr,'),''String'')); '...
	  'volSize=viewSize(',view.name,'); ',...
	  'sliceNum=clip(sliceNum,1,volSize(',bstr,')); '...
	  'set(',view.name,'.ui.sliceNumFields(',bstr,'),''String'',num2str(sliceNum)); '...
	  'clear sliceNum volSize; ',...
	  view.name,'=refreshScreen(',view.name,');'];
  view.ui.sliceNumFields(b) = ...
      uicontrol('Style','edit',...
      'BackgroundColor',[1 1 1],...
...%      'String',num2str(1),...
      'String',num2str(round(sz(b)/2)),...
      'Units','normalized',...
      'Position',[left,bot,width,height],...
      'Callback', callbackStr);
end


% Prev button
% Callback:
%   sliceNum=getCurSlice(view)-1;
%   setCurSlice(view,sliceNum);
%   clear sliceNum;
%   view=refreshScreen(view);
callbackStr = ...
    ['sliceNum=getCurSlice(',view.name,')-1; '...
	'setCurSlice(',view.name,',sliceNum); '...
	'clear sliceNum; ',...
	view.name,'=refreshScreen(',view.name,');'];
previousBtn= ...
    uicontrol('Style','pushbutton',...
    'String','<< Prev',...
    'Units','normalized',... 
    'Position',[.3 .07 .1 .05], ...
    'Callback', callbackStr);

% Next button
% Callback:
%   sliceNum=getCurSlice(view)+1;
%   setCurSlice(view,sliceNum);
%   clear sliceNum;
%   view=refreshScreen(view);
callbackStr = ...
    ['sliceNum=getCurSlice(',view.name,')+1; '...
	'setCurSlice(',view.name,',sliceNum); '...
	'clear sliceNum; ',...
	view.name,'=refreshScreen(',view.name,');'];
nextBtn= ...
    uicontrol('Style','pushbutton',...
    'String','Next >>',...
    'Units','normalized',... 
    'Position',[.5 .07 .1 .05], ...
    'Callback', callbackStr);

return;
