function view=make3ViewSliceUI(view)
%
% view=make3ViewSliceUI(view)
%
% Installs:
%   slice orientation buttons (axi=button 1, cor=button 2, sag=button 3)
%   editable text fields for slice numbers
%   prev and next push buttons
%
% djh, 7/98
% ras, 06/03, adapted from makeVolSliceUI

% Slice orientation buttons
width = .1;
height = .05;
left = .225;
buttonLabels=['Axi'; 'Cor'; 'Sag'];
for b = 1:3
    bot= 0.25 + (b-1)*0.05;
    % Callback:
    %   setCurSliceOri(view, b);
    cb = sprintf('setCurSliceOri(%s, %i); ', view.name, b); 
    view.ui.sliceOriButtons(b) = ...
        uicontrol('Style', 'radiobutton',...
        'String', buttonLabels(b,:),...
        'BackgroundColor', get(gcf,'Color'),...
        'Units', 'normalized',...
        'Position', [left,bot,width,height],...
        'Callback',  cb);
end

% Slice num fields
width = .1;
height = .05;
left = .325;
for b = 1:3
    bot= 0.25 + (b-1)*0.05;
    
    % Callback:
    %   sliceNum=str2num(get(view.ui.sliceNumFields(b),'String'));
    %   volSize=viewSize(view);
    %   sliceNum=clip(sliceNum,1,volSize(b));
    %   set(view.ui.sliceNumFields(b),'String',num2str(sliceNum));
    %   clear sliceNum volSize;
    %   view=update3ViewLoc(view);
    bstr=num2str(b);
    cb = ...
        ['sliceNum=str2num(get(',view.name,'.ui.sliceNumFields(',bstr,'),''String'')); '...
            'volSize=viewSize(',view.name,'); ',...
            'sliceNum=clip(sliceNum,1,volSize(',bstr,')); '...
            'set(',view.name,'.ui.sliceNumFields(',bstr,'),''String'',num2str(sliceNum)); '...
            'clear sliceNum volSize; ',...
            view.name,'=update3ViewLoc(',view.name,');'];
    view.ui.sliceNumFields(b) = ...
        uicontrol('Style','edit',...
        'BackgroundColor',get(gcf,'Color'),...
        'String',num2str(1),...
        'Units','normalized',...
        'Position',[left,bot,width,height],...
        'Callback', cb);
end


% Prev button
% Callback:
%   sliceNum=getCurSlice(view)-1;
%   setCurSlice(view,sliceNum);
%   clear sliceNum;
%   view=update3ViewLoc(view);
cb = ...
    ['sliceNum=getCurSlice(',view.name,')-1; '...
        'setCurSlice(',view.name,',sliceNum); '...
        'clear sliceNum; ',...
        view.name,'=update3ViewLoc(',view.name,');'];
previousBtn= ...
    uicontrol('Style','pushbutton',...
    'String','<< Prev',...
    'Units','normalized',... 
    'BackgroundColor',get(gcf,'Color'),...
    'Position',[.225 .2 .1 .05], ...
    'Callback', cb);

% Next button
% Callback:
%   sliceNum=getCurSlice(view)+1;
%   setCurSlice(view,sliceNum);
%   clear sliceNum;
%   view=update3ViewLoc(view);
cb = ...
    ['sliceNum=getCurSlice(',view.name,')+1; '...
        'setCurSlice(',view.name,',sliceNum); '...
        'clear sliceNum; ',...
        view.name,'=update3ViewLoc(',view.name,');'];
nextBtn= ...
    uicontrol('Style','pushbutton',...
    'String','Next >>',...
    'BackgroundColor',get(gcf,'Color'),...
    'Units','normalized',... 
    'Position',[.325 .2 .1 .05], ...
    'Callback', cb);

return;
