function view = setCurSlice(view,sliceNum)
%
% view = setCurSlice(view,sliceNum)
%
% For VOLUME, updates the editable text.  For INPLANE/FLAT,
% selects button corresponding to sliceNum.
%
% djh, 8/98
% bw,  12.15.00
%     Made adjustment for setting FLAT view.  This was
%     needed to manage the new INPLANE UI with multiple slices.
% ras, 04/04 
%     Made adjustments in parallel with changes in makeSlider
%     and setSlider, for inplane view
% ras, 06/06: now deals w/ hidden views, by using the tSeriesSlice
% field.
if isequal(view.name,'hidden')
    view.tSeriesSlice = sliceNum;
    return
end

switch view.viewType
    case 'Inplane'
        setSlider(view,view.ui.slice,sliceNum);
        
        % remove the trailing 
        str = sprintf('%.0f',sliceNum);
        set(view.ui.slice.labelHandle,'String',str);
        
    case {'Volume','Gray'}
        volSize = viewSize(view);
        sliceOri=getCurSliceOri(view);
        sliceNum=clip(sliceNum,1,volSize(sliceOri));
        set(view.ui.sliceNumFields(sliceOri),'String',num2str(sliceNum));
        
    case 'Flat'
        % ras 10/04: compatible w/ flat level view
        if sliceNum <= 2
            h = sliceNum;
        else
            if sliceNum > 2+view.numLevels(1)
                h = 2;
            else
                h = 1;
            end
        end
        selectButton(view.ui.sliceButtons,h)
end

return
