function view=makeSliceButtons(view)
%
% view=makeSliceButtons(view)
%
% Installs push buttons that set curSlice.
% This is used for the inplane view only.
%
% djh, 1/97
% bw, 12.08.00.  For more than 12 planes, we put up a slider
% instead of the individual buttons
%

if ~strcmp('Inplane',view.viewType)
   error('makeSliceButtons:  Only called for INPLANE');
end

nSlices = numSlices(view);

if nSlices <= 12
   % sliceButtons all placed individually on the left.
   width = .07; height = .05; left = .01;
   for z=1:nSlices
      bot=z*.8/nSlices;
      % Callback:
      %   selectButton(view.ui.sliceButtons,z);
      %   view=refreshScreen(view);
      callbackStr = ...
         ['selectButton(',view.name,'.ui.sliceButtons,',num2str(z),'); ',...
            view.name,'=refreshScreen(',view.name,');'];
      view.ui.sliceButtons(z) = ...
         uicontrol('Style','radiobutton',...
         'String',int2str(z),...
         'Units','normalized',...
         'Position',[left,bot,width,height],...
         'Callback', callbackStr);
   end
   
else
   % Use a slider and next/prev buttons to move through the slices
   % This is the position of the number field
   
   % Callback:
   %   sliceNum=str2num(get(view.ui.sliceNumFields(1),'String'));
   %   sliceNum=clip(sliceNum,1,numSlices(view));
   %   set(view.ui.sliceNumFields,'String',num2str(sliceNum));
   %   clear sliceNum dims;
   %   view=refreshScreen(view);
   callbackStr = ...
      ['sliceNum=str2num(get(',view.name,'.ui.sliceNumFields(1),''String'')); '...
         'sliceNum=clip(sliceNum,1,numSlices(',view.name,')); '...
         'set(',view.name,'.ui.sliceNumFields,''String'',num2str(sliceNum)); '...
         'clear sliceNum volSize; ',...
         view.name,'=refreshScreen(',view.name,');'];
   %
   left = .01; width = .07; height = .05; bot= .5;
   view.ui.sliceNumFields = ...
      uicontrol('Style','edit',...
      'BackgroundColor',[1 1 1],...
      'String',num2str(1),...
      'Units','normalized',...
      'Position',[left,bot,width,height],...
      'Callback', callbackStr);
   
   
   % Prev button
   % Callback:
   %   sliceNum=getCurSlice(view)-1;
   %   setCurSlice(view,sliceNum);
   %   clear sliceNum;
   %   view=refreshScreen(view);
   
   callbackStr = ...
      ['sliceNum=getCurSlice(',view.name,')-1; '...
         'setCurSlice(',view.name,',sliceNum); '...
         'clear sliceNum; ',...
         view.name,'=refreshScreen(',view.name,');'];
   bot= .45;
   view.ui.previousBtn= ...
      uicontrol('Style','pushbutton',...
      'String','<<',...
      'Units','normalized',... 
      'Position',[left,bot,width,height], ...
      'Callback', callbackStr);
   
   % Next button
   % Callback:
   %   sliceNum=getCurSlice(view)+1;
   %   setCurSlice(view,sliceNum);
   %   clear sliceNum;
   %   view=refreshScreen(view);
   callbackStr = ...
      ['sliceNum=getCurSlice(',view.name,')+1; '...
         'setCurSlice(',view.name,',sliceNum); '...
         'clear sliceNum; ',...
         view.name,'=refreshScreen(',view.name,');'];
   
   bot= .55;
   view.ui.nextBtn= ...
      uicontrol('Style','pushbutton',...
      'String','>>',...
      'Units','normalized',... 
      'Position',[left,bot,width,height], ...
      'Callback', callbackStr);
   
end

return;
